/*
 * Decompiled with CFR 0.152.
 */
package com.nanorep.nanoclient.network;

import android.net.Uri;
import android.os.AsyncTask;
import android.util.Log;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;

public class GetBinaryHttpTask
extends AsyncTask<Void, Void, ByteArrayOutputStream> {
    private HttpBinaryResponse responseListener;
    private URL url;

    public GetBinaryHttpTask(String strUrl, HttpBinaryResponse listener) {
        this.responseListener = listener;
        try {
            this.url = new URL(strUrl);
        }
        catch (MalformedURLException e) {
            listener.error();
        }
    }

    public GetBinaryHttpTask(Uri uri, HttpBinaryResponse listener) {
        this.responseListener = listener;
        try {
            this.url = new URL(uri.toString());
        }
        catch (MalformedURLException e) {
            listener.error();
        }
    }

    protected ByteArrayOutputStream doInBackground(Void ... v) {
        try {
            int charsRead;
            Log.i((String)"image fetch", (String)("start - " + this.url));
            HttpURLConnection httpConnection = (HttpURLConnection)this.url.openConnection();
            httpConnection.setRequestMethod("GET");
            InputStream inputStream = httpConnection.getInputStream();
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((charsRead = inputStream.read(buffer)) != -1) {
                bos.write(buffer, 0, charsRead);
            }
            inputStream.close();
            httpConnection.disconnect();
            Log.i((String)"image fetch", (String)("end   - " + this.url));
            return bos;
        }
        catch (NullPointerException | MalformedURLException e) {
            return null;
        }
        catch (ProtocolException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    protected void onPostExecute(ByteArrayOutputStream response) {
        if (response == null) {
            this.responseListener.error();
            return;
        }
        this.responseListener.success(response.toByteArray());
        try {
            response.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static interface HttpBinaryResponse {
        public void success(byte[] var1);

        public void error();
    }
}

