/*
 * Decompiled with CFR 0.152.
 */
package com.nanorep.nanoclient;

import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.text.style.StyleSpan;
import android.util.Base64;
import android.util.Log;
import com.nanorep.nanoclient.AccountParams;
import com.nanorep.nanoclient.Channeling.NRChanneling;
import com.nanorep.nanoclient.Connection.NRConnection;
import com.nanorep.nanoclient.Connection.NRError;
import com.nanorep.nanoclient.Connection.NRUtilities;
import com.nanorep.nanoclient.Interfaces.NRExtraDataListener;
import com.nanorep.nanoclient.Log.NRLogger;
import com.nanorep.nanoclient.RequestParams.NRFAQLikeParams;
import com.nanorep.nanoclient.RequestParams.NRSearchLikeParams;
import com.nanorep.nanoclient.Response.NRConfiguration;
import com.nanorep.nanoclient.Response.NRFAQAnswer;
import com.nanorep.nanoclient.Response.NRSearchResponse;
import com.nanorep.nanoclient.Response.NRSuggestions;
import com.nanorep.nanoclient.exception.NRConnectionException;
import com.nanorep.nanoclient.model.DefaultResponse;
import com.nanorep.nanoclient.model.HelloResponse;
import com.nanorep.nanoclient.network.OnDataResponse;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Nanorep {
    private static Nanorep instance;
    private int httpRequestTimeout;
    private Runnable keepAliveRunnable;
    private int keepAliveCounter;
    private boolean helloInProgress;
    private Handler keepAliveHandler;
    private AccountParams mAccountParams;
    private NRConfiguration mCnf;
    private NRLogger nrLogger;
    private String mSessionId;
    private long mDelay;
    private HashMap<String, NRSearchResponse> mCachedSearches;
    private HashMap<String, NRSuggestions> mCachedSuggestions;
    private HashMap<String, ArrayList<OnFAQAnswerFetchedListener>> faqRequestListenersMap;
    private NanoRepWidgetListener widgetListener;
    private String searchQuery;
    private boolean keepAliveRunning;

    public static void initialize(AccountParams accountParams, NanoRepWidgetListener widgetListener) {
        instance = new Nanorep();
        instance.init(accountParams, widgetListener);
    }

    public static void initialize(AccountParams accountParams) {
        instance = new Nanorep();
        instance.init(accountParams);
    }

    public static Nanorep getInstance() {
        if (instance == null) {
            throw new RuntimeException("Nanorep is not initialized");
        }
        return instance;
    }

    public NanoRepWidgetListener getWidgetListener() {
        return this.widgetListener;
    }

    public void setWidgetListener(NanoRepWidgetListener widgetListener) {
        this.widgetListener = widgetListener;
    }

    public String getSessionId() {
        return this.mSessionId;
    }

    public int getHttpRequestTimeout() {
        return this.httpRequestTimeout;
    }

    public static boolean isInitialized() {
        return instance != null;
    }

    public void setHttpRequestTimeout(int httpRequestTimeout) {
        if (httpRequestTimeout >= 3 && httpRequestTimeout <= 60) {
            this.httpRequestTimeout = httpRequestTimeout;
        }
    }

    public void setAccountParams(AccountParams accountParams) {
        this.mAccountParams = accountParams;
    }

    private void init(AccountParams accountParams, NanoRepWidgetListener widgetListener) {
        this.keepAliveHandler = new Handler();
        this.mCachedSearches = new HashMap();
        this.clearCache();
        this.widgetListener = widgetListener;
        if (this.getAccountParams() != null && accountParams.compareTo(this.getAccountParams()) != 0) {
            this.mCnf = null;
        }
        this.setAccountParams(accountParams);
        this.nrLogger = new NRLogger();
        this.fetchConfiguration();
    }

    private void init(AccountParams accountParams) {
        this.keepAliveHandler = new Handler();
        this.mCachedSearches = new HashMap();
        this.clearCache();
        if (this.getAccountParams() != null && accountParams.compareTo(this.getAccountParams()) != 0) {
            this.mCnf = null;
        }
        this.setAccountParams(accountParams);
        this.nrLogger = new NRLogger();
        this.fetchConfiguration();
    }

    public void reset() {
        this.mSessionId = null;
        if (this.keepAliveHandler != null) {
            this.keepAliveHandler.removeCallbacksAndMessages(null);
        }
    }

    private HashMap<String, NRSearchResponse> getCachedSearches() {
        if (this.mCachedSearches == null) {
            this.mCachedSearches = new HashMap();
        }
        return this.mCachedSearches;
    }

    private HashMap<String, NRSuggestions> getCachedSuggestions() {
        if (this.mCachedSuggestions == null) {
            this.mCachedSuggestions = new HashMap();
        }
        return this.mCachedSuggestions;
    }

    private HashMap<String, ArrayList<OnFAQAnswerFetchedListener>> getFaqRequestListenersMap() {
        if (this.faqRequestListenersMap == null) {
            this.faqRequestListenersMap = new HashMap();
        }
        return this.faqRequestListenersMap;
    }

    public void clearCache() {
        if (this.mCachedSearches != null) {
            Log.i((String)"formData", (String)"cache cleared");
            this.mCachedSearches.clear();
        }
    }

    private void keepAlive(final long interval) {
        ++this.keepAliveCounter;
        Log.i((String)"nanorep", (String)("keepalive called (" + this.keepAliveCounter + ")"));
        if (this.keepAliveRunnable == null) {
            this.keepAliveRunnable = new Runnable(){

                @Override
                public void run() {
                    Nanorep.this.keepAlive(interval);
                }
            };
        }
        this.keepAliveHandler.postDelayed(this.keepAliveRunnable, interval);
        if (this.keepAliveRunning) {
            Log.i((String)"nanorep", (String)"keepalive - in progress deteceted");
            return;
        }
        Log.i((String)"nanorep", (String)"keepalive - sending http request");
        this.keepAliveRunning = true;
        Uri.Builder uri = this.mAccountParams.getUri();
        uri.appendEncodedPath("api/widget/v1/keepAlive.js");
        uri.appendQueryParameter("sid", this.mSessionId);
        NRConnection.connection(uri, new OnDataResponse<String>(){

            @Override
            public void onSuccess(String response) {
                Nanorep.this.keepAliveRunning = false;
                Log.i((String)"nanorep", (String)("keepalive - success " + response));
            }

            @Override
            public void onError(NRConnectionException error) {
                Log.i((String)"nanorep", (String)"keepalive - error ");
                Nanorep.this.keepAliveRunning = false;
                Nanorep.this.keepAliveHandler.removeCallbacks(Nanorep.this.keepAliveRunnable);
                Nanorep.this.createSession(new OnDataResponse<HelloResponse>(){

                    @Override
                    public void onSuccess(HelloResponse response) {
                    }

                    @Override
                    public void onError(NRConnectionException error) {
                        Nanorep.this.widgetListener.onInitializationFailure();
                    }
                });
            }
        });
    }

    public void reportChanneling(String articleId, String type, String channelName) {
        Uri.Builder uri = this.mAccountParams.getUri();
        uri.appendEncodedPath("api/channeling/v1/report");
        uri.appendQueryParameter("account", this.mAccountParams.getAccount());
        uri.appendQueryParameter("kb", this.mAccountParams.getKnowledgeBase());
        uri.appendQueryParameter("articleId", articleId);
        uri.appendQueryParameter("trafficSource", "FAQ");
        uri.appendQueryParameter("reportedEscalationType", type);
        uri.appendQueryParameter("apiName", channelName);
        NRConnection.connection(uri, new OnDataResponse<String>(){

            @Override
            public void onSuccess(String response) {
            }

            @Override
            public void onError(NRConnectionException error) {
            }
        });
    }

    private void executeRequest(final Uri.Builder uriBuilder, final NRConnection.Listener executeListener) {
        if (this.mSessionId != null) {
            uriBuilder.appendQueryParameter("sid", this.mSessionId);
            NRConnection.getInstance().connectionWithRequest(uriBuilder.build(), new NRConnection.Listener(){

                @Override
                public void response(final Object responseParam, int status, NRError error) {
                    if (error != null || responseParam == null) {
                        Uri.Builder uri = Nanorep.this.mAccountParams.getUri();
                        uri.appendEncodedPath("api/widget/v1/keepAlive.js");
                        uri.appendQueryParameter("sid", Nanorep.this.mSessionId);
                        NRConnection.connection(uri, new OnDataResponse<String>(){

                            @Override
                            public void onSuccess(String response) {
                                Log.i((String)"nanorep", (String)("keepalive - success " + response));
                                this.onError(new NRConnectionException("response error"));
                            }

                            @Override
                            public void onError(NRConnectionException error) {
                                Log.i((String)"nanorep", (String)"keepalive - error, calling createSession ");
                                Nanorep.this.renewSession(executeListener, responseParam);
                            }
                        });
                    } else {
                        executeListener.response(responseParam, 200, null);
                    }
                }

                @Override
                public void log(String tag, String msg) {
                }
            });
        } else {
            this.createSession(new OnDataResponse<HelloResponse>(){

                @Override
                public void onSuccess(HelloResponse response) {
                    Nanorep.this.executeRequest(uriBuilder, executeListener);
                }

                @Override
                public void onError(NRConnectionException error) {
                }
            });
        }
    }

    private void renewSession(final NRConnection.Listener executeListener, final Object responseParam) {
        this.keepAliveRunning = false;
        this.keepAliveHandler.removeCallbacks(this.keepAliveRunnable);
        this.mSessionId = "";
        this.createSession(new OnDataResponse<HelloResponse>(){

            @Override
            public void onSuccess(HelloResponse response) {
                executeListener.response(responseParam, 200, null);
            }

            @Override
            public void onError(NRConnectionException error) {
                Nanorep.this.widgetListener.onInitializationFailure();
            }
        });
    }

    private void hello_deprecated(final NRConnection.Listener listener) {
        if (this.helloInProgress) {
            return;
        }
        Uri.Builder _uriBuilder = this.mAccountParams.getUri();
        _uriBuilder.appendQueryParameter("kb", this.mAccountParams.getKnowledgeBase());
        _uriBuilder.appendEncodedPath("api/widget/v1/hello.js");
        _uriBuilder.appendQueryParameter("nostats", "false");
        _uriBuilder.appendQueryParameter("url", "mobile");
        String context = this.mAccountParams.getContext();
        if (context != null) {
            _uriBuilder.appendQueryParameter("context", context);
        }
        this.helloInProgress = true;
        NRConnection.getInstance().connectionWithRequest(_uriBuilder.build(), new NRConnection.Listener(){

            @Override
            public void response(Object responseParam, int status, NRError error) {
                Nanorep.this.helloInProgress = false;
                if (error != null) {
                    Log.e((String)"Nanorep", (String)error.getDescription());
                } else {
                    Nanorep.this.mSessionId = (String)((HashMap)responseParam).get("sessionId");
                    Nanorep.this.mDelay = ((Integer)((HashMap)responseParam).get("timeout")).longValue() * 500L;
                    Log.i((String)"nanorep", (String)"_hello success - calling keepalive");
                    Nanorep.this.keepAlive(Nanorep.this.mDelay);
                    listener.response(responseParam, status, error);
                }
            }

            @Override
            public void log(String tag, String msg) {
                Nanorep.this.nrLogger.log(tag, msg);
            }
        });
    }

    private void createSession(final OnDataResponse<HelloResponse> sessionListener) {
        Uri.Builder uri = this.mAccountParams.getUri();
        uri.appendQueryParameter("kb", this.mAccountParams.getKnowledgeBase());
        uri.appendEncodedPath("api/widget/v1/hello.js");
        uri.appendQueryParameter("nostats", "false");
        uri.appendQueryParameter("url", "mobile");
        if (this.mAccountParams.getContext() != null) {
            uri.appendQueryParameter("context", this.mAccountParams.getContext());
        }
        NRConnection.connection(uri, new OnDataResponse<HelloResponse>(){

            @Override
            public void onSuccess(HelloResponse response) {
                Nanorep.this.mSessionId = response.getSessionId();
                Log.i((String)"nanorep", (String)"createSession success - calling keepalive");
                Nanorep.this.keepAlive(response.getTimeout() * 1000 / 2);
                sessionListener.onSuccess(response);
            }

            @Override
            public void onError(NRConnectionException error) {
                sessionListener.onError(error);
            }
        });
    }

    public void removeFromSearchCache(String text) {
        if (this.mCachedSearches != null && this.mCachedSearches.containsKey(text)) {
            this.mCachedSearches.remove(text);
        }
    }

    public void searchText(final String text, final OnSearchResultsFetchedListener onSearchResultsFetchedListener) {
        if (this.mCachedSearches != null && this.mCachedSearches.get(text) != null) {
            onSearchResultsFetchedListener.onSearchResponse(this.mCachedSearches.get(text), null);
        } else if (text != null && text.length() > 0) {
            String encodedText = null;
            try {
                encodedText = URLEncoder.encode(text, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            Uri.Builder uriBuilder = this.mAccountParams.getUri();
            uriBuilder.appendEncodedPath("api/widget/v1/q.js");
            uriBuilder.appendQueryParameter("text", text);
            this.executeRequest(uriBuilder, new NRConnection.Listener(){

                @Override
                public void response(Object responseParam, int status, NRError error) {
                    if (error != null) {
                        onSearchResultsFetchedListener.onSearchResponse(null, error);
                    } else if (responseParam != null) {
                        NRSearchResponse response = new NRSearchResponse((HashMap)responseParam);
                        Nanorep.this.getCachedSearches().put(text, response);
                        onSearchResultsFetchedListener.onSearchResponse(response, null);
                    }
                }

                @Override
                public void log(String tag, String msg) {
                    Nanorep.this.nrLogger.log(tag, msg);
                }
            });
        }
    }

    public void getContextValues(String context, OnDataResponse<String> listener) {
        Uri.Builder uriBuilder = this.mAccountParams.getUri();
        uriBuilder.appendEncodedPath("api/kb/v1/contextValues");
        uriBuilder.appendQueryParameter("contexts", context);
        uriBuilder.appendQueryParameter("account", this.getAccountParams().getAccount());
        uriBuilder.appendQueryParameter("kb", this.getAccountParams().getKnowledgeBase());
        uriBuilder.appendQueryParameter("cb", "");
        NRConnection.connection(uriBuilder, listener);
    }

    public void setContext(final String context, final OnDataResponse<DefaultResponse> listener) {
        if (this.mSessionId == null) {
            if (context == null) {
                return;
            }
            this.createSession(new OnDataResponse<HelloResponse>(){

                @Override
                public void onSuccess(HelloResponse response) {
                    Nanorep.this.setSessionParams(context, listener);
                }

                @Override
                public void onError(NRConnectionException error) {
                    Nanorep.this.widgetListener.onEmptyDataResponse();
                }
            });
        } else {
            this.setSessionParams(context, listener);
        }
    }

    private void setSessionParams(String context, OnDataResponse<DefaultResponse> listener) {
        if (context == null) {
            this.clearCache();
            this.mAccountParams.clearSelectedContext();
        } else {
            this.mAccountParams.setSelectedContext(context);
            context = this.mAccountParams.getSelectedContext();
        }
        this.clearCache();
        String initContext = this.mAccountParams.getContext();
        if (initContext != null && initContext.length() > 0) {
            context = initContext + "," + context;
        }
        Uri.Builder uriBuilder = this.mAccountParams.getUri();
        uriBuilder.appendEncodedPath("api/widget/v1/setParams");
        uriBuilder.appendQueryParameter("context", context == null ? "clearContext:" : context);
        uriBuilder.appendQueryParameter("sid", this.mSessionId);
        uriBuilder.appendQueryParameter("account", this.getAccountParams().getAccount());
        NRConnection.connection(uriBuilder, listener);
    }

    public void getChanneling(String articleId, boolean isPositive, final OnDataResponse<List<NRChanneling>> listener) {
        Uri.Builder uriBuilder = this.mAccountParams.getUri();
        uriBuilder.appendEncodedPath("api/channeling/v1/get");
        uriBuilder.appendQueryParameter("account", this.getAccountParams().getAccount());
        uriBuilder.appendQueryParameter("kb", this.getAccountParams().getKnowledgeBase());
        uriBuilder.appendQueryParameter("articleId", articleId);
        uriBuilder.appendQueryParameter("clientState", isPositive ? "positiveFeedback" : "negativeFeedback");
        if (this.mAccountParams.getCurrentLabelContext() != null) {
            uriBuilder.appendQueryParameter("context", this.mAccountParams.getCurrentLabelContext());
        }
        this.executeRequest(uriBuilder, new NRConnection.Listener(){

            @Override
            public void response(Object responseParam, int status, NRError error) {
                if (error != null) {
                    listener.onError(null);
                } else if (responseParam != null) {
                    List channeling = (List)((HashMap)responseParam).get("rechanneling");
                    if (channeling == null) {
                        return;
                    }
                    ArrayList<NRChanneling> nrChannels = new ArrayList<NRChanneling>();
                    for (HashMap channel : channeling) {
                        nrChannels.add(NRChanneling.channelForParams(channel));
                    }
                    listener.onSuccess(nrChannels);
                }
            }

            @Override
            public void log(String tag, String msg) {
                Nanorep.this.nrLogger.log(tag, msg);
            }
        });
    }

    public void updateFaqList(String hexLabelId, String nrContext, boolean ignoreLabelContext, NRConnection.Listener listener) {
        AccountParams accountParams = Nanorep.getInstance().getAccountParams();
        Uri.Builder uri = accountParams.getUri();
        uri.appendEncodedPath("api/kb/v1/faq");
        uri.appendQueryParameter("account", accountParams.getAccount());
        uri.appendQueryParameter("kb", accountParams.getKnowledgeBase());
        if (!accountParams.isContextExclusivity()) {
            uri.appendQueryParameter("allContextsMandatory", "false");
        }
        uri.appendQueryParameter("items", "1000");
        if (hexLabelId != null) {
            uri.appendQueryParameter("labelId", hexLabelId);
        } else if (!accountParams.isLabelsMode() && accountParams.getLabelId() != 0) {
            uri.appendQueryParameter("labelId", Integer.toHexString(accountParams.getLabelId()).toUpperCase());
        }
        String ctx = null;
        String currentContext = accountParams.getContext();
        if (ignoreLabelContext) {
            ctx = nrContext;
        } else {
            this.mAccountParams.setCurrentLabelContext(nrContext);
            if (currentContext != null && currentContext.length() > 0) {
                ctx = currentContext + (nrContext != null && nrContext.length() > 0 ? "," + nrContext : "");
            } else if (nrContext != null && nrContext.length() > 0) {
                ctx = nrContext;
            }
        }
        try {
            if (ctx != null && ctx.length() > 0) {
                String b64ctx = Base64.encodeToString((byte[])ctx.getBytes("UTF-8"), (int)0);
                if (b64ctx.endsWith("\n")) {
                    b64ctx = b64ctx.substring(0, b64ctx.length() - 1);
                }
                uri.appendQueryParameter("context", b64ctx);
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        accountParams.setLabelsMode(false);
        NRConnection.getInstance().connectionWithRequest(uri.build(), listener);
    }

    public void suggestionsForText(final String text, final OnSuggestionsFetchedListener onSuggestionsFetchedListener) {
        if (this.mCachedSuggestions != null && this.mCachedSuggestions.get(text) != null) {
            onSuggestionsFetchedListener.onSuggestionsFetched(this.mCachedSuggestions.get(text), null);
        } else if (text != null && text.length() > 0) {
            Uri.Builder uriBuilder = this.mAccountParams.getUri();
            uriBuilder.appendEncodedPath("api/kb/v1/autoComplete");
            uriBuilder.appendQueryParameter("text", text);
            uriBuilder.appendQueryParameter("stemming", "true");
            this.executeRequest(uriBuilder, new NRConnection.Listener(){

                @Override
                public void response(Object responseParam, int status, NRError error) {
                    if (responseParam != null) {
                        ArrayList answers = (ArrayList)((HashMap)responseParam).get("a");
                        Nanorep.this.searchQuery = text;
                        if (answers != null) {
                            ArrayList suggestions = Nanorep.this.getSpannables(answers);
                            ((HashMap)responseParam).put("a", suggestions);
                            Nanorep.this.getCachedSuggestions().put(text, new NRSuggestions((HashMap)responseParam));
                            onSuggestionsFetchedListener.onSuggestionsFetched((NRSuggestions)Nanorep.this.mCachedSuggestions.get(text), null);
                        } else {
                            onSuggestionsFetchedListener.onSuggestionsFetched(null, NRError.error("nanorep", 1002, "No suggestions"));
                        }
                    } else if (error != null) {
                        NRSuggestions storedSuggestions = (NRSuggestions)Nanorep.this.getCachedSuggestions().get(text);
                        if (storedSuggestions == null) {
                            onSuggestionsFetchedListener.onSuggestionsFetched(null, NRError.error("nanorep", 1003, "No suggestions in cache"));
                        } else {
                            onSuggestionsFetchedListener.onSuggestionsFetched(storedSuggestions, null);
                        }
                    }
                }

                @Override
                public void log(String tag, String msg) {
                    Nanorep.this.nrLogger.log(tag, msg);
                }
            });
        }
    }

    private ArrayList<Spannable> getSpannables(ArrayList<String> answers) {
        ArrayList<Spannable> suggestions = new ArrayList<Spannable>();
        for (String answer : answers) {
            suggestions.add(this.getSpannable(answer));
        }
        return suggestions;
    }

    public Spannable getSpannable(String text) {
        SpannableStringBuilder str = new SpannableStringBuilder();
        String[] originalWords = this.searchQuery.split("\\s+");
        String[] pipes = text.split("\\|");
        for (int i = 0; i < pipes.length; ++i) {
            StyleSpan styleSpan;
            String[] words = pipes[i].split(",");
            String word = words[0];
            if (words[words.length - 1].endsWith("*")) {
                if (words.length == 1) {
                    word = word.substring(0, word.length() - 1);
                }
                styleSpan = new StyleSpan(this.isWordInArray(word, originalWords) ? 0 : 1);
            } else {
                styleSpan = new StyleSpan(0);
            }
            String wordSpace = word + " ";
            if (i == pipes.length - 1) {
                wordSpace = word;
            }
            if (Build.VERSION.SDK_INT >= 21) {
                str.append((CharSequence)wordSpace, (Object)styleSpan, 0);
                continue;
            }
            int startIndex = str.length();
            str.append((CharSequence)wordSpace);
            str.setSpan((Object)styleSpan, startIndex, str.length(), 0);
        }
        return str;
    }

    private boolean isWordInArray(String needle, String[] originalWords) {
        if (originalWords == null || originalWords.length == 0) {
            return false;
        }
        for (String word : originalWords) {
            if (!word.equals(needle)) continue;
            return true;
        }
        return false;
    }

    public void likeForSearchResult(NRSearchLikeParams likeParams, final OnLikeSentListener onLikeSentListener) {
        Uri.Builder uriBuilder = this.mAccountParams.getUri();
        uriBuilder.appendEncodedPath("api/widget/v1/thumb.js");
        for (String key : likeParams.getParams().keySet()) {
            uriBuilder.appendQueryParameter(key, likeParams.getParams().get(key));
        }
        this.executeRequest(uriBuilder, new NRConnection.Listener(){

            @Override
            public void response(Object responseParam, int status, NRError error) {
                if (error != null) {
                    onLikeSentListener.onLikeSent(false);
                } else if (responseParam != null) {
                    onLikeSentListener.onLikeSent(true);
                }
            }

            @Override
            public void log(String tag, String msg) {
                Nanorep.this.nrLogger.log(tag, msg);
            }
        });
    }

    public void fetchFAQAnswer(final String answerId, Integer answerHash, OnFAQAnswerFetchedListener onFAQAnswerFetchedListener) {
        Uri.Builder uriBuilder = this.mAccountParams.getUri();
        uriBuilder.appendEncodedPath("api/faq/v1/answer.js");
        uriBuilder.appendQueryParameter("id", answerId);
        uriBuilder.appendQueryParameter("referer", this.getAccountParams().getReferrer());
        uriBuilder.appendQueryParameter("kb", this.getAccountParams().getKnowledgeBase());
        ArrayList<OnFAQAnswerFetchedListener> onFAQAnswerFetchedListenerArr = this.getFaqRequestListenersMap().get(answerId);
        if (onFAQAnswerFetchedListenerArr == null) {
            onFAQAnswerFetchedListenerArr = new ArrayList();
            onFAQAnswerFetchedListenerArr.add(onFAQAnswerFetchedListener);
            this.getFaqRequestListenersMap().put(answerId, onFAQAnswerFetchedListenerArr);
            final ArrayList<OnFAQAnswerFetchedListener> finalOnFAQAnswerFetchedListenerArr = onFAQAnswerFetchedListenerArr;
            this.executeRequest(uriBuilder, new NRConnection.Listener(){

                @Override
                public void response(Object responseParam, int status, NRError error) {
                    if (responseParam != null) {
                        ((HashMap)responseParam).put("id", answerId);
                    }
                    for (OnFAQAnswerFetchedListener listener : finalOnFAQAnswerFetchedListenerArr) {
                        if (error != null) {
                            listener.onFAQAnswerFetched(null, error);
                            continue;
                        }
                        if (responseParam == null) continue;
                        listener.onFAQAnswerFetched(new NRFAQAnswer((HashMap)responseParam), null);
                    }
                    Nanorep.this.getFaqRequestListenersMap().remove(answerId);
                }

                @Override
                public void log(String tag, String msg) {
                    Nanorep.this.nrLogger.log(tag, msg);
                }
            });
        }
    }

    public void likeForFAQResult(NRFAQLikeParams likeParams, final OnLikeSentListener onLikeSentListener) {
        Uri.Builder uriBuilder = this.mAccountParams.getUri();
        uriBuilder.appendEncodedPath("api/analytics/v1/addFeedback");
        uriBuilder.appendQueryParameter("ignoreValidateCookie", "true");
        if (this.mAccountParams.getKnowledgeBase() != null) {
            uriBuilder.appendQueryParameter("kb", this.mAccountParams.getKnowledgeBase());
        }
        for (String key : likeParams.getParams().keySet()) {
            uriBuilder.appendQueryParameter(key, likeParams.getParams().get(key));
        }
        if (this.mSessionId != null) {
            uriBuilder.appendQueryParameter("sid", this.mSessionId);
        }
        NRConnection.getInstance().connectionWithRequest(uriBuilder.build(), new NRConnection.Listener(){

            @Override
            public void response(Object responseParam, int status, NRError error) {
                if (error != null) {
                    onLikeSentListener.onLikeSent(false);
                } else if (responseParam instanceof HashMap) {
                    onLikeSentListener.onLikeSent(true);
                }
            }

            @Override
            public void log(String tag, String msg) {
                Nanorep.this.nrLogger.log(tag, msg);
            }
        });
    }

    public void fetchConfiguration() {
        if (this.mAccountParams != null) {
            Uri.Builder uri = this.mAccountParams.getUri(false);
            uri.appendEncodedPath("widget/scripts/cnf.json");
            if (this.mAccountParams.getKnowledgeBase() != null) {
                uri.appendQueryParameter("kb", this.mAccountParams.getKnowledgeBase());
            }
            uri.appendQueryParameter("isFloat", "true");
            uri.appendQueryParameter("context", this.mAccountParams.getContext());
            uri.appendQueryParameter("referer", NRUtilities.buildReferer(this.getAccountParams().getReferrer()));
            NRConnection.connection(uri, new OnDataResponse<String>(){

                @Override
                public void onSuccess(String response) {
                    Object retMap = NRUtilities.jsonStringToPropertyList(response);
                    if (retMap == null || !(retMap instanceof Map)) {
                        Nanorep.this.widgetListener.onInitializationFailure();
                        return;
                    }
                    Nanorep.this.mCnf = new NRConfiguration((HashMap)retMap);
                    Nanorep.this.mAccountParams.setKnowledgeBaseId(Nanorep.this.mCnf.getKbId());
                    Nanorep.this.widgetListener.onConfigurationFetched();
                }

                @Override
                public void onError(NRConnectionException error) {
                    Nanorep.this.widgetListener.onInitializationFailure();
                }
            });
        }
    }

    public NRConfiguration getNRConfiguration() {
        if (this.mCnf == null) {
            this.mCnf = new NRConfiguration();
        }
        return this.mCnf;
    }

    public AccountParams getAccountParams() {
        return this.mAccountParams;
    }

    public static interface OnConfigurationFetchedListener {
        public void onConfigurationFetched(NRError var1);
    }

    public static interface OnFAQAnswerFetchedListener {
        public void onFAQAnswerFetched(NRFAQAnswer var1, NRError var2);
    }

    public static interface OnLikeSentListener {
        public void onLikeSent(boolean var1);
    }

    public static interface OnSuggestionsFetchedListener {
        public void onSuggestionsFetched(NRSuggestions var1, NRError var2);
    }

    public static interface OnSearchResultsFetchedListener {
        public void onSearchResponse(NRSearchResponse var1, NRError var2);
    }

    public static interface NRCachedImageResponder {
        public void onBitmapResponse(Bitmap var1);
    }

    public static interface NanoRepWidgetListener {
        public void personalInfoWithExtraData(String var1, String var2, NRExtraDataListener var3);

        public void onSubmitSupportForm(String var1, ArrayList<String> var2);

        public void onConfigurationFetched();

        public void onCachedImageRequest(String var1, NRCachedImageResponder var2);

        public void onInitializationFailure();

        public void onEmptyDataResponse();

        public void onChannel(NRChanneling.NRChannelingType var1, Object var2);
    }
}

