/*
 * Decompiled with CFR 0.152.
 */
package com.nanorep.nanoclient.Connection;

import android.net.Uri;
import android.os.AsyncTask;
import android.os.Build;
import android.util.Log;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.nanorep.nanoclient.Connection.NRDownloader;
import com.nanorep.nanoclient.Connection.NRError;
import com.nanorep.nanoclient.Connection.NRUtilities;
import com.nanorep.nanoclient.Handlers.NRErrorHandler;
import com.nanorep.nanoclient.exception.NRConnectionException;
import com.nanorep.nanoclient.network.GetHttpTask;
import com.nanorep.nanoclient.network.HttpResponse;
import com.nanorep.nanoclient.network.OnDataResponse;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;

public class NRConnection {
    private static String NRStatusKey = "status";
    private static String TAG_REQUEST = "nanoRepDebugRequest";
    private static String TAG_RESPONSE = "nanoRepDebugResponse";
    private ArrayList<NRDownloader> mConnections;
    private static NRConnection mInstance;

    private NRConnection() {
    }

    public static <T> void connection(final Uri.Builder uri, final OnDataResponse dataResponse) {
        GetHttpTask httpTask = new GetHttpTask(uri.build(), new HttpResponse(){

            @Override
            public void success(String data) {
                if (data == null) {
                    dataResponse.onError(new NRConnectionException(data));
                } else {
                    NRConnection.log(uri.toString(), data);
                    try {
                        Type type = dataResponse.getType();
                        if (type.equals(String.class)) {
                            dataResponse.onSuccess(data);
                        } else {
                            Object t = new Gson().fromJson(data, dataResponse.getType());
                            if (t == null) {
                                throw new JsonSyntaxException("data is empty");
                            }
                            dataResponse.onSuccess(t);
                        }
                    }
                    catch (JsonSyntaxException jse) {
                        dataResponse.onError(new NRConnectionException(data, (Exception)((Object)jse)));
                    }
                }
            }

            @Override
            public void error() {
                dataResponse.onError(new NRConnectionException(""));
            }
        });
        httpTask.execute(new Void[0]);
    }

    private static void log(String url, String data) {
        Log.i((String)"NRConnection", (String)url);
        Log.i((String)"NRConnection", (String)data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static NRConnection getInstance() {
        if (mInstance != null) return mInstance;
        Class<NRConnection> clazz = NRConnection.class;
        synchronized (NRConnection.class) {
            if (mInstance != null) return mInstance;
            mInstance = new NRConnection();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    public void connectionWithRequest(Uri uri, final Listener listener) {
        NRDownloader downloader = new NRDownloader(new NRDownloader.NRDownloaderListener(){

            @Override
            public void downloadCompleted(NRDownloader downloader, Object data, NRError error) {
                if (listener != null) {
                    if (error != null) {
                        listener.response(null, -1, error);
                        NRErrorHandler.getInstance().handleError(error.getCode());
                    } else {
                        NRErrorHandler.getInstance().reset();
                        String jsonString = "";
                        Object retMap = new HashMap();
                        if (data != null) {
                            jsonString = new String((byte[])data);
                            retMap = NRUtilities.jsonStringToPropertyList(jsonString);
                        }
                        listener.log(TAG_RESPONSE, jsonString);
                        listener.response(retMap, downloader.getResponseStatus(), null);
                    }
                }
                if (NRConnection.this.mConnections != null && NRConnection.this.mConnections.contains((Object)downloader)) {
                    NRConnection.this.mConnections.remove((Object)downloader);
                }
            }
        });
        listener.log(TAG_REQUEST, uri.toString());
        if (Build.VERSION.SDK_INT >= 11) {
            downloader.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Uri[]{uri});
        } else {
            downloader.execute(new Uri[]{uri});
        }
    }

    public void cancelAllConnections() {
        ArrayList<NRDownloader> downloaders = new ArrayList<NRDownloader>(this.getConnections());
        for (NRDownloader downloader : downloaders) {
            downloader.cancel(true);
            this.getConnections().remove((Object)downloader);
            Object var3_3 = null;
        }
        this.mConnections = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<NRDownloader> getConnections() {
        ArrayList<NRDownloader> arrayList = this.mConnections;
        synchronized (arrayList) {
            if (this.mConnections == null) {
                this.mConnections = new ArrayList();
            }
            return this.mConnections;
        }
    }

    public static interface Listener {
        public void response(Object var1, int var2, NRError var3);

        public void log(String var1, String var2);
    }
}

