/*
 * Decompiled with CFR 0.152.
 */
package com.nanorep.nanoclient.Response;

import android.util.Log;
import android.util.Xml;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class NRHtmlParser {
    private String mHtmlString;

    public NRHtmlParser(String htmlString) {
        this.mHtmlString = htmlString;
    }

    public String getParsedHtml() {
        try {
            XmlPullParserFactory pullParserFactory = XmlPullParserFactory.newInstance();
            XmlPullParser parser = pullParserFactory.newPullParser();
            parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", false);
            parser.setInput((Reader)new StringReader(this.mHtmlString));
            parser.setFeature(Xml.FEATURE_RELAXED, true);
            return this.parseHtml(parser);
        }
        catch (XmlPullParserException e) {
            e.printStackTrace();
            return null;
        }
    }

    private String parseHtml(XmlPullParser parser) {
        try {
            int eventType = parser.getEventType();
            while (eventType != 1) {
                switch (eventType) {
                    case 2: {
                        if (!parser.getName().equals("a") || this.getValue("nanoreplinkid", parser) == null) break;
                        String idStr = "nanorep://id/" + this.getValue("nanoreplinkid", parser);
                        this.mHtmlString = this.mHtmlString.replace("javascript:void(0)", idStr);
                        Log.d((String)"test", (String)this.getValue("nanoreplinkid", parser));
                        return this.mHtmlString;
                    }
                }
                eventType = parser.next();
            }
        }
        catch (XmlPullParserException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.mHtmlString;
    }

    private String getValue(String attribute, XmlPullParser parser) {
        for (int i = 0; i < parser.getAttributeCount(); ++i) {
            if (!parser.getAttributeName(i).equals(attribute)) continue;
            return parser.getAttributeValue(i);
        }
        return null;
    }
}

