/*
 * Decompiled with CFR 0.152.
 */
package com.nanorep.nanoclient.Channeling;

import com.nanorep.nanoclient.Channeling.NRChannelingChatForm;
import com.nanorep.nanoclient.Channeling.NRChannelingContactForm;
import com.nanorep.nanoclient.Channeling.NRChannelingCustomScript;
import com.nanorep.nanoclient.Channeling.NRChannelingOpenCustomURL;
import com.nanorep.nanoclient.Channeling.NRChannelingPhoneNumber;
import com.nanorep.nanoclient.Interfaces.NRQueryResult;
import java.util.HashMap;
import java.util.Map;

public class NRChanneling {
    protected String buttonText;
    protected String channelDescription;
    protected NRChannelingType type;
    protected NRQueryResult mQueryResult;
    protected HashMap<String, Object> mParams;
    private Map<String, String> extraData;
    private String noResultExtra;

    public String getName() {
        if (this.mParams != null && this.mParams.containsKey("name")) {
            return (String)this.mParams.get("name");
        }
        return "";
    }

    public void setExtraData(Map<String, String> extraData) {
        this.extraData = extraData;
    }

    public String getExtraData() {
        if (this.extraData == null || this.extraData.size() == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder("{");
        for (Map.Entry<String, String> entry : this.extraData.entrySet()) {
            sb.append(String.format("\"%s\": \"%s\",", entry.getKey(), entry.getValue()));
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append("}");
        return sb.toString();
    }

    public void setNoResultExtra(String noResultExtra) {
        this.noResultExtra = noResultExtra;
    }

    public String getNoResultExtra() {
        return this.noResultExtra;
    }

    public NRChanneling(HashMap<String, ?> params) {
        this.mParams = params;
        this.buttonText = this.value("buttonText");
        this.channelDescription = this.value("description");
    }

    protected String value(String key) {
        if (key != null) {
            return (String)this.mParams.get(key);
        }
        return null;
    }

    protected Boolean booleanValue(String key) {
        if (key != null) {
            return (Boolean)this.mParams.get(key);
        }
        return null;
    }

    public String getButtonText() {
        return this.buttonText;
    }

    public String getChannelDescription() {
        return this.channelDescription;
    }

    public NRChannelingType getType() {
        return this.type;
    }

    public void setQueryResult(NRQueryResult queryResult) {
        this.mQueryResult = queryResult;
    }

    public NRQueryResult getQueryResult() {
        return this.mQueryResult;
    }

    public static NRChanneling channelForParams(HashMap<String, Object> params) {
        int actionEsc = Integer.parseInt((String)params.get("actionEsc"));
        switch (actionEsc) {
            case 1: {
                return new NRChannelingOpenCustomURL(params);
            }
            case 2: {
                return new NRChannelingCustomScript(params);
            }
            case 0: {
                switch (Integer.parseInt((String)params.get("channel"))) {
                    case 5: {
                        return new NRChannelingPhoneNumber(params);
                    }
                    case 3: {
                        return new NRChannelingChatForm(params);
                    }
                    case 1: {
                        return new NRChannelingContactForm(params);
                    }
                }
            }
        }
        return null;
    }

    public static enum NRChannelingType {
        PhoneNumber,
        OpenCustomURL,
        CustomScript,
        ContactForm,
        ChatForm;

    }
}

