/*
 * Decompiled with CFR 0.152.
 */
package com.nanorep.nanoclient.Connection;

import android.net.Uri;
import android.os.AsyncTask;
import android.util.Log;
import com.nanorep.nanoclient.Connection.NRError;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;

public class NRDownloader
extends AsyncTask<Uri, Integer, Object> {
    private NRDownloaderListener mListener;
    private int mStatus;
    public static final int TIMEOUT = 2000;

    public NRDownloader(NRDownloaderListener listener) {
        this.mListener = listener;
    }

    public int getResponseStatus() {
        return this.mStatus;
    }

    protected Object doInBackground(Uri ... uris) {
        Uri uri = uris[0];
        Log.i((String)"url", (String)uri.toString());
        URL url = null;
        byte[] data = null;
        try {
            url = new URL(uri.toString());
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(10000);
            connection.setRequestProperty("Referer", uri.getQueryParameter("referer"));
            connection.connect();
            BufferedInputStream inputStream = new BufferedInputStream(connection.getInputStream());
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            int next = ((InputStream)inputStream).read();
            while (next > -1) {
                bos.write(next);
                next = ((InputStream)inputStream).read();
            }
            data = bos.toByteArray();
            ((InputStream)inputStream).close();
            connection.disconnect();
            bos.flush();
            bos.close();
            Log.i((String)"url", (String)new String(data));
            this.mStatus = connection.getResponseCode();
        }
        catch (SocketTimeoutException e) {
            e.printStackTrace();
            return NRError.error("Connection", 2000, e.getMessage());
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            return NRError.error("Connection", 2000, e.getMessage());
        }
        catch (ConnectException e) {
            e.printStackTrace();
            return NRError.error("Connection", 2000, e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            return NRError.error("Connection", 1000, e.getMessage());
        }
        return data;
    }

    protected void onProgressUpdate(Integer ... values) {
    }

    protected void onPostExecute(Object bytes) {
        if (bytes instanceof NRError) {
            this.mListener.downloadCompleted(this, null, (NRError)bytes);
        } else if (this.mStatus == 200 && ((byte[])bytes).length > 0) {
            this.mListener.downloadCompleted(this, bytes, null);
        } else if (this.mStatus == 200 && ((byte[])bytes).length == 0) {
            this.mListener.downloadCompleted(this, null, null);
        } else {
            this.mListener.downloadCompleted(this, null, NRError.error("Parsed Response", 1001, "Empty response"));
        }
    }

    public static interface NRDownloaderListener {
        public void downloadCompleted(NRDownloader var1, Object var2, NRError var3);
    }
}

