/*
 * Decompiled with CFR 0.152.
 */
package com.nabto.api;

import android.util.Log;
import com.nabto.api.NabtoAssetManager;
import com.nabto.api.NabtoCApiWrapper;
import com.nabto.api.NabtoConnectionType;
import com.nabto.api.NabtoStatus;
import com.nabto.api.NabtoStreamOption;
import com.nabto.api.RpcResult;
import com.nabto.api.Session;
import com.nabto.api.Stream;
import com.nabto.api.StreamReadResult;
import com.nabto.api.Tunnel;
import com.nabto.api.TunnelInfoResult;
import com.nabto.api.UrlResult;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;

public class NabtoApi {
    private NabtoAssetManager assetManager;

    public NabtoApi(NabtoAssetManager assetManager) {
        this.assetManager = assetManager;
    }

    @Deprecated
    public String version() {
        return NabtoCApiWrapper.nabtoVersion();
    }

    public String versionString() {
        return NabtoCApiWrapper.nabtoVersionString();
    }

    public NabtoStatus startup() {
        String dir = this.assetManager.getNabtoHomeDirectory();
        NabtoStatus status = NabtoCApiWrapper.nabtoStartup(dir);
        if (status == NabtoStatus.OK) {
            status = NabtoCApiWrapper.nabtoInstallDefaultStaticResources(this.assetManager.getNabtoHomeDirectory());
            if (status == NabtoStatus.OK) {
                Log.i((String)this.getClass().getSimpleName(), (String)("Started Nabto Client SDK in " + dir));
            } else {
                Log.e((String)this.getClass().getSimpleName(), (String)("Nabto started but resources could not be installed in " + dir));
            }
        } else {
            Log.e((String)this.getClass().getSimpleName(), (String)("Failed to startup Nabto client API: " + (Object)((Object)status)));
        }
        return status;
    }

    public NabtoStatus setStaticResourceDir(String dir) {
        return NabtoCApiWrapper.nabtoInstallDefaultStaticResources(dir);
    }

    public NabtoStatus shutdown() {
        NabtoStatus status = NabtoCApiWrapper.nabtoShutdown();
        if (status != NabtoStatus.OK) {
            Log.d((String)this.getClass().getSimpleName(), (String)("Failed to shutdown Nabto client API: " + (Object)((Object)status)));
        }
        return status;
    }

    public NabtoStatus setOption(String name, String value) {
        NabtoStatus status = NabtoCApiWrapper.nabtoSetOption(name, value);
        if (status != NabtoStatus.OK) {
            Log.d((String)this.getClass().getSimpleName(), (String)("Failed to set option on Nabto client API: " + (Object)((Object)status)));
        }
        return status;
    }

    public Collection<String> getProtocolPrefixes() {
        ArrayList<String> prefixes = new ArrayList<String>();
        String[] res = NabtoCApiWrapper.nabtoGetProtocolPrefixes();
        if (res != null) {
            for (String s : res) {
                prefixes.add(s);
            }
        } else {
            Log.d((String)this.getClass().getSimpleName(), (String)"Failed to get protocol prefixes.");
        }
        return prefixes;
    }

    public Collection<String> getLocalDevices() {
        ArrayList<String> devices = new ArrayList<String>();
        String[] res = NabtoCApiWrapper.nabtoGetLocalDevices();
        if (res != null) {
            for (String s : res) {
                devices.add(s);
            }
        } else {
            Log.d((String)this.getClass().getSimpleName(), (String)"Failed to get local devices.");
        }
        return devices;
    }

    public NabtoStatus probeNetwork(int timeoutMillis, String hostname) {
        NabtoStatus status = NabtoCApiWrapper.nabtoProbeNetwork(timeoutMillis, hostname);
        if (status != NabtoStatus.OK) {
            Log.d((String)this.getClass().getSimpleName(), (String)("Failed to probe network: " + (Object)((Object)status)));
        }
        return status;
    }

    public Collection<String> getCertificates() {
        ArrayList<String> certificates = new ArrayList<String>();
        String[] res = NabtoCApiWrapper.nabtoGetCertificates();
        if (res != null) {
            for (String s : res) {
                certificates.add(s);
            }
        } else {
            Log.d((String)this.getClass().getSimpleName(), (String)"Failed to get certificates.");
        }
        return certificates;
    }

    public NabtoStatus createProfile(String id, String password) {
        NabtoStatus status = NabtoCApiWrapper.nabtoCreateProfile(id, password);
        if (status != NabtoStatus.OK) {
            Log.d((String)this.getClass().getSimpleName(), (String)("Failed to create profile: " + (Object)((Object)status)));
        }
        return status;
    }

    public NabtoStatus removeProfile(String certId) {
        NabtoStatus status = NabtoCApiWrapper.nabtoRemoveProfile(certId);
        if (status != NabtoStatus.OK) {
            Log.d((String)this.getClass().getSimpleName(), (String)("Failed to remove profile: " + (Object)((Object)status)));
        }
        return status;
    }

    public NabtoStatus createSelfSignedProfile(String commonName, String password) {
        NabtoStatus status = NabtoCApiWrapper.nabtoCreateSelfSignedProfile(commonName, password);
        if (status != NabtoStatus.OK) {
            Log.d((String)this.getClass().getSimpleName(), (String)("Failed to create profile: " + (Object)((Object)status)));
        }
        return status;
    }

    public NabtoStatus getFingerprint(String certId, String[] fingerprint) {
        byte[] byteFingerprint = new byte[16];
        NabtoStatus ret = NabtoCApiWrapper.nabtoGetFingerprint(certId, byteFingerprint);
        for (int i = 0; i < byteFingerprint.length; ++i) {
            fingerprint[0] = fingerprint[0] + String.format("%02x", byteFingerprint[i]);
        }
        return ret;
    }

    public NabtoStatus signup(String email, String password) {
        NabtoStatus status = NabtoCApiWrapper.nabtoSignup(email, password);
        if (status != NabtoStatus.OK) {
            Log.d((String)this.getClass().getSimpleName(), (String)("Failed to sign up: " + (Object)((Object)status)));
        }
        return status;
    }

    public NabtoStatus resetAccountPassword(String email) {
        NabtoStatus status = NabtoCApiWrapper.nabtoResetAccountPassword(email);
        if (status != NabtoStatus.OK) {
            Log.d((String)this.getClass().getSimpleName(), (String)("Failed to reset account password: " + (Object)((Object)status)));
        }
        return status;
    }

    public Session openSession(String id, String password) {
        Session session = NabtoCApiWrapper.nabtoOpenSession(id, password);
        if (session.getStatus() != NabtoStatus.OK) {
            Log.d((String)this.getClass().getSimpleName(), (String)("Failed to open session: " + (Object)((Object)session.getStatus())));
        }
        return session;
    }

    public Session openSessionBare() {
        Session session = NabtoCApiWrapper.nabtoOpenSessionBare();
        if (session.getStatus() != NabtoStatus.OK) {
            Log.d((String)this.getClass().getSimpleName(), (String)("Failed to open bare session: " + (Object)((Object)session.getStatus())));
        }
        return session;
    }

    public NabtoStatus closeSession(Session session) {
        NabtoStatus status = NabtoCApiWrapper.nabtoCloseSession(session);
        if (status != NabtoStatus.OK) {
            Log.d((String)this.getClass().getSimpleName(), (String)("Failed to close session: " + (Object)((Object)status)));
        }
        return status;
    }

    public NabtoStatus setBasestationAuthJson(String jsonKeyValuePairs, Session session) {
        NabtoStatus status = NabtoCApiWrapper.nabtoSetBasestationAuthJson(jsonKeyValuePairs, session);
        if (status != NabtoStatus.OK) {
            Log.d((String)this.getClass().getSimpleName(), (String)("Failed to set basestation authentication info: " + (Object)((Object)status)));
        }
        return status;
    }

    public RpcResult rpcSetDefaultInterface(String interfaceDefinition, Session session) {
        RpcResult rpcResult = NabtoCApiWrapper.nabtoRpcSetDefaultInterface(interfaceDefinition, session);
        if (rpcResult.getStatus() != NabtoStatus.OK) {
            Log.d((String)this.getClass().getSimpleName(), (String)("Failed to set default RPC interface: " + (Object)((Object)rpcResult.getStatus())));
        }
        return rpcResult;
    }

    public RpcResult rpcSetInterface(String nabtoHost, String interfaceDefinition, Session session) {
        RpcResult rpcResult = NabtoCApiWrapper.nabtoRpcSetInterface(nabtoHost, interfaceDefinition, session);
        if (rpcResult.getStatus() != NabtoStatus.OK) {
            Log.d((String)this.getClass().getSimpleName(), (String)("Failed to set RPC interface: " + (Object)((Object)rpcResult.getStatus())));
        }
        return rpcResult;
    }

    public RpcResult rpcInvoke(String nabtoUrl, Session session) {
        RpcResult rpcResult = NabtoCApiWrapper.nabtoRpcInvoke(nabtoUrl, session);
        if (rpcResult.getStatus() != NabtoStatus.OK) {
            Log.d((String)this.getClass().getSimpleName(), (String)("Failed to invoke RPC: " + (Object)((Object)rpcResult.getStatus())));
        }
        return rpcResult;
    }

    public UrlResult fetchUrl(String nabtoUrl, Session session) {
        UrlResult result = NabtoCApiWrapper.nabtoFetchUrl(nabtoUrl, session);
        if (result.getStatus() != NabtoStatus.OK) {
            Log.d((String)this.getClass().getSimpleName(), (String)("Failed to fetch URL: " + (Object)((Object)result.getStatus())));
        }
        return result;
    }

    public UrlResult submitPostData(String nabtoUrl, byte[] postData, String postMimeType, Session session) {
        UrlResult result = NabtoCApiWrapper.nabtoSubmitPostData(nabtoUrl, postData, postMimeType, session);
        if (result.getStatus() != NabtoStatus.OK) {
            Log.d((String)this.getClass().getSimpleName(), (String)("Failed to submit post data: " + (Object)((Object)result.getStatus())));
        }
        return result;
    }

    public String getSessionToken(Session session) {
        String token = NabtoCApiWrapper.nabtoGetSessionToken(session);
        if (token == null) {
            Log.d((String)this.getClass().getSimpleName(), (String)"Failed get session token.");
            token = "";
        }
        return token;
    }

    public Stream streamOpen(String nabtoHost, Session session) {
        Stream stream = NabtoCApiWrapper.nabtoStreamOpen(nabtoHost, session);
        if (stream.getStatus() != NabtoStatus.OK) {
            Log.d((String)this.getClass().getSimpleName(), (String)("Failed to open stream: " + (Object)((Object)stream.getStatus())));
        }
        return stream;
    }

    public NabtoStatus streamClose(Stream stream) {
        NabtoStatus status = NabtoCApiWrapper.nabtoStreamClose(stream);
        if (status != NabtoStatus.OK) {
            Log.d((String)this.getClass().getSimpleName(), (String)("Failed to close stream: " + (Object)((Object)status)));
        }
        return status;
    }

    public StreamReadResult streamRead(Stream stream) {
        StreamReadResult result = NabtoCApiWrapper.nabtoStreamRead(stream);
        if (result.getStatus() != NabtoStatus.OK) {
            Log.d((String)this.getClass().getSimpleName(), (String)("Failed to read from stream: " + (Object)((Object)result.getStatus())));
        }
        return result;
    }

    public NabtoStatus streamWrite(Stream stream, byte[] data) {
        NabtoStatus status = NabtoCApiWrapper.nabtoStreamWrite(data, stream);
        if (status != NabtoStatus.OK) {
            Log.d((String)this.getClass().getSimpleName(), (String)("Failed to write to stream: " + (Object)((Object)status)));
        }
        return status;
    }

    public NabtoConnectionType streamConnectionType(Stream stream) {
        return NabtoCApiWrapper.nabtoStreamConnectionType(stream);
    }

    public NabtoStatus streamSetOption(Stream stream, NabtoStreamOption option, int value) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        byteBuffer.putInt(value);
        NabtoStatus status = NabtoCApiWrapper.nabtoStreamSetOption(option.toInteger(), byteBuffer.array(), stream);
        if (status != NabtoStatus.OK) {
            Log.d((String)this.getClass().getSimpleName(), (String)("Failed to set stream option: " + (Object)((Object)status)));
        }
        return status;
    }

    public Tunnel tunnelOpenTcp(int localPort, String nabtoHost, String remoteHost, int remotePort, Session session) {
        Tunnel tunnel = NabtoCApiWrapper.nabtoTunnelOpenTcp(localPort, nabtoHost, remoteHost, remotePort, session);
        if (tunnel.getStatus() != NabtoStatus.OK) {
            Log.d((String)this.getClass().getSimpleName(), (String)("Failed to open TCP tunnel: " + (Object)((Object)tunnel.getStatus())));
        }
        return tunnel;
    }

    public NabtoStatus tunnelClose(Tunnel tunnel) {
        NabtoStatus status = NabtoCApiWrapper.nabtoTunnelClose(tunnel);
        if (status != NabtoStatus.OK) {
            Log.d((String)this.getClass().getSimpleName(), (String)("Failed to close tunnel: " + (Object)((Object)status)));
        }
        return status;
    }

    public TunnelInfoResult tunnelInfo(Tunnel tunnel) {
        TunnelInfoResult info = NabtoCApiWrapper.nabtoTunnelInfo(tunnel);
        if (info.getStatus() != NabtoStatus.OK) {
            Log.d((String)this.getClass().getSimpleName(), (String)("Failed to get tunnel info: " + (Object)((Object)info.getStatus())));
        }
        return info;
    }
}

