/*
 * Decompiled with CFR 0.152.
 */
package com.metamx.collections.spatial;

import com.google.common.base.Preconditions;
import com.metamx.collections.spatial.Node;
import com.metamx.collections.spatial.Point;
import com.metamx.collections.spatial.RTreeUtils;
import com.metamx.collections.spatial.split.LinearGutmanSplitStrategy;
import com.metamx.collections.spatial.split.SplitStrategy;
import it.uniroma3.mat.extendedset.intset.ConciseSet;
import java.util.Arrays;

public class RTree {
    private final int numDims;
    private final SplitStrategy splitStrategy;
    private Node root;
    private volatile int size;

    public RTree() {
        this(0, new LinearGutmanSplitStrategy(0, 0));
    }

    public RTree(int numDims, SplitStrategy splitStrategy) {
        this.numDims = numDims;
        this.splitStrategy = splitStrategy;
        this.root = this.buildRoot(true);
    }

    public void insert(float[] coords, int entry) {
        Preconditions.checkArgument((coords.length == this.numDims ? 1 : 0) != 0);
        this.insertInner(new Point(coords, entry));
    }

    public void insert(float[] coords, ConciseSet entry) {
        Preconditions.checkArgument((coords.length == this.numDims ? 1 : 0) != 0);
        this.insertInner(new Point(coords, entry));
    }

    public boolean delete(double[] coords, int entry) {
        throw new UnsupportedOperationException();
    }

    public int getSize() {
        return this.size;
    }

    public int getNumDims() {
        return this.numDims;
    }

    public SplitStrategy getSplitStrategy() {
        return this.splitStrategy;
    }

    public Node getRoot() {
        return this.root;
    }

    private Node buildRoot(boolean isLeaf) {
        float[] initMinCoords = new float[this.numDims];
        float[] initMaxCoords = new float[this.numDims];
        Arrays.fill(initMinCoords, -3.4028235E38f);
        Arrays.fill(initMaxCoords, Float.MAX_VALUE);
        return new Node(initMinCoords, initMaxCoords, isLeaf);
    }

    private void insertInner(Point point) {
        Node node = this.chooseLeaf(this.root, point);
        node.addChild(point);
        if (this.splitStrategy.needToSplit(node)) {
            Node[] groups = this.splitStrategy.split(node);
            this.adjustTree(groups[0], groups[1]);
        } else {
            this.adjustTree(node, null);
        }
        ++this.size;
    }

    private Node chooseLeaf(Node node, Point point) {
        node.addToConciseSet(point);
        if (node.isLeaf()) {
            return node;
        }
        double minCost = Double.MAX_VALUE;
        Node optimal = null;
        for (Node child : node.getChildren()) {
            double cost = RTreeUtils.getExpansionCost(child, point);
            if (cost < minCost) {
                minCost = cost;
                optimal = child;
                continue;
            }
            if (cost != minCost || !(child.getArea() < optimal.getArea())) continue;
            optimal = child;
        }
        return this.chooseLeaf(optimal, point);
    }

    private void adjustTree(Node n, Node nn) {
        if (n == this.root) {
            if (nn != null) {
                this.root = this.buildRoot(false);
                this.root.addChild(n);
                this.root.addChild(nn);
            }
            this.root.enclose();
            return;
        }
        boolean updateParent = n.enclose();
        if (nn != null) {
            nn.enclose();
            updateParent = true;
            if (this.splitStrategy.needToSplit(n.getParent())) {
                Node[] groups = this.splitStrategy.split(n.getParent());
                this.adjustTree(groups[0], groups[1]);
            }
        }
        if (n.getParent() != null && updateParent) {
            this.adjustTree(n.getParent(), null);
        }
    }
}

