/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.sql.spatial;

import com.mysema.query.sql.types.AbstractType;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.annotation.Nullable;
import org.geolatte.geom.ByteBuffer;
import org.geolatte.geom.ByteOrder;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.codec.Wkb;
import org.geolatte.geom.codec.WkbDecoder;
import org.geolatte.geom.codec.WkbEncoder;
import org.geolatte.geom.codec.Wkt;

public class GeometryWkbType
extends AbstractType<Geometry> {
    public static final GeometryWkbType NDR = new GeometryWkbType(ByteOrder.NDR);
    public static final GeometryWkbType XDR = new GeometryWkbType(ByteOrder.XDR);
    private final ByteOrder byteOrder;

    public GeometryWkbType(ByteOrder byteOrder) {
        super(1111);
        this.byteOrder = byteOrder;
    }

    @Override
    public Class<Geometry> getReturnedClass() {
        return Geometry.class;
    }

    @Override
    @Nullable
    public Geometry getValue(ResultSet rs, int startIndex) throws SQLException {
        byte[] bytes = rs.getBytes(startIndex);
        if (bytes != null) {
            WkbDecoder decoder = Wkb.newDecoder((Wkb.Dialect)Wkb.Dialect.POSTGIS_EWKB_1);
            return decoder.decode(ByteBuffer.from((byte[])bytes));
        }
        return null;
    }

    @Override
    public void setValue(PreparedStatement st, int startIndex, Geometry value) throws SQLException {
        WkbEncoder encoder = Wkb.newEncoder((Wkb.Dialect)Wkb.Dialect.POSTGIS_EWKB_1);
        ByteBuffer buffer = encoder.encode(value, this.byteOrder);
        st.setBytes(startIndex, buffer.toByteArray());
    }

    @Override
    public String getLiteral(Geometry geometry) {
        return "'" + Wkt.newEncoder((Wkt.Dialect)Wkt.Dialect.POSTGIS_EWKT_1).encode(geometry) + "'";
    }
}

