/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.sql.mysql;

import com.mysema.query.QueryFlag;
import com.mysema.query.sql.AbstractSQLQueryFactory;
import com.mysema.query.sql.Configuration;
import com.mysema.query.sql.MySQLTemplates;
import com.mysema.query.sql.RelationalPath;
import com.mysema.query.sql.SQLSubQuery;
import com.mysema.query.sql.SQLTemplates;
import com.mysema.query.sql.dml.SQLInsertClause;
import com.mysema.query.sql.mysql.MySQLQuery;
import com.mysema.query.sql.mysql.MySQLReplaceClause;
import com.mysema.query.types.Expression;
import com.mysema.query.types.TemplateExpressionImpl;
import java.sql.Connection;
import javax.inject.Provider;

public class MySQLQueryFactory
extends AbstractSQLQueryFactory<MySQLQuery, SQLSubQuery> {
    public MySQLQueryFactory(Configuration configuration, Provider<Connection> connection) {
        super(configuration, connection);
    }

    public MySQLQueryFactory(Provider<Connection> connection) {
        this(new Configuration(new MySQLTemplates()), connection);
    }

    public MySQLQueryFactory(SQLTemplates templates, Provider<Connection> connection) {
        this(new Configuration(templates), connection);
    }

    public SQLInsertClause insertIgnore(RelationalPath<?> entity) {
        SQLInsertClause insert = this.insert(entity);
        insert.addFlag(QueryFlag.Position.START_OVERRIDE, "insert ignore into ");
        return insert;
    }

    public SQLInsertClause insertOnDuplicateKeyUpdate(RelationalPath<?> entity, String clause) {
        SQLInsertClause insert = this.insert(entity);
        insert.addFlag(QueryFlag.Position.END, " on duplicate key update " + clause);
        return insert;
    }

    public SQLInsertClause insertOnDuplicateKeyUpdate(RelationalPath<?> entity, Expression<?> clause) {
        SQLInsertClause insert = this.insert(entity);
        insert.addFlag(QueryFlag.Position.END, TemplateExpressionImpl.create(String.class, (String)" on duplicate key update {0}", clause));
        return insert;
    }

    @Override
    public MySQLQuery query() {
        return new MySQLQuery((Connection)this.connection.get(), this.configuration);
    }

    public MySQLReplaceClause replace(RelationalPath<?> entity) {
        return new MySQLReplaceClause((Connection)this.connection.get(), this.configuration, entity);
    }
}

