/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.sql;

import com.mysema.query.sql.CUBRIDTemplates;
import com.mysema.query.sql.DerbyTemplates;
import com.mysema.query.sql.FirebirdTemplates;
import com.mysema.query.sql.H2Templates;
import com.mysema.query.sql.HSQLDBTemplates;
import com.mysema.query.sql.MySQLTemplates;
import com.mysema.query.sql.OracleTemplates;
import com.mysema.query.sql.PostgresTemplates;
import com.mysema.query.sql.SQLServer2005Templates;
import com.mysema.query.sql.SQLServer2008Templates;
import com.mysema.query.sql.SQLServer2012Templates;
import com.mysema.query.sql.SQLServerTemplates;
import com.mysema.query.sql.SQLTemplates;
import com.mysema.query.sql.SQLiteTemplates;
import com.mysema.query.sql.TeradataTemplates;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;

public class SQLTemplatesRegistry {
    private final SQLTemplates generic = SQLTemplates.DEFAULT;
    private final SQLTemplates cubrid = new CUBRIDTemplates();
    private final SQLTemplates derby = new DerbyTemplates();
    private final SQLTemplates firebird = new FirebirdTemplates();
    private final SQLTemplates h2 = new H2Templates();
    private final SQLTemplates hsqldb = new HSQLDBTemplates();
    private final SQLTemplates mysql = new MySQLTemplates();
    private final SQLTemplates oracle = new OracleTemplates();
    private final SQLTemplates postgres = new PostgresTemplates();
    private final SQLTemplates sqlite = new SQLiteTemplates();
    private final SQLTemplates teradata = new TeradataTemplates();
    private final SQLTemplates sqlserver = new SQLServerTemplates();
    private final SQLTemplates sqlserver2005 = new SQLServer2005Templates();
    private final SQLTemplates sqlserver2008 = new SQLServer2008Templates();
    private final SQLTemplates sqlserver2012 = new SQLServer2012Templates();

    public SQLTemplates getTemplates(DatabaseMetaData md) throws SQLException {
        String name = md.getDatabaseProductName().toLowerCase();
        if (name.equals("cubrid")) {
            return this.cubrid;
        }
        if (name.equals("apache derby")) {
            return this.derby;
        }
        if (name.startsWith("firebird")) {
            return this.firebird;
        }
        if (name.equals("h2")) {
            return this.h2;
        }
        if (name.equals("hsql")) {
            return this.hsqldb;
        }
        if (name.equals("mysql")) {
            return this.mysql;
        }
        if (name.equals("oracle")) {
            return this.oracle;
        }
        if (name.equals("postgresql")) {
            return this.postgres;
        }
        if (name.equals("sqlite")) {
            return this.sqlite;
        }
        if (name.startsWith("teradata")) {
            return this.teradata;
        }
        if (name.equals("microsft sql server")) {
            switch (md.getDatabaseMajorVersion()) {
                case 11: 
                case 12: {
                    return this.sqlserver2012;
                }
                case 10: {
                    return this.sqlserver2008;
                }
                case 9: {
                    return this.sqlserver2005;
                }
            }
            return this.sqlserver;
        }
        return this.generic;
    }
}

