/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.sql;

import com.google.common.collect.ImmutableList;
import com.mysema.query.BooleanBuilder;
import com.mysema.query.Tuple;
import com.mysema.query.sql.RelationalPath;
import com.mysema.query.types.CollectionExpression;
import com.mysema.query.types.Expression;
import com.mysema.query.types.ExpressionUtils;
import com.mysema.query.types.Operator;
import com.mysema.query.types.Ops;
import com.mysema.query.types.Path;
import com.mysema.query.types.PathImpl;
import com.mysema.query.types.Predicate;
import com.mysema.query.types.ProjectionRole;
import com.mysema.query.types.expr.BooleanExpression;
import com.mysema.query.types.expr.BooleanOperation;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class ForeignKey<E>
implements Serializable,
ProjectionRole<Tuple> {
    private static final long serialVersionUID = 2260578033772289023L;
    private final RelationalPath<?> entity;
    private final ImmutableList<? extends Path<?>> localColumns;
    private final ImmutableList<String> foreignColumns;
    @Nullable
    private volatile Expression<Tuple> mixin;

    public ForeignKey(RelationalPath<?> entity, Path<?> localColumn, String foreignColumn) {
        this(entity, ImmutableList.of(localColumn), (ImmutableList<String>)ImmutableList.of((Object)foreignColumn));
    }

    public ForeignKey(RelationalPath<?> entity, ImmutableList<? extends Path<?>> localColumns, ImmutableList<String> foreignColumns) {
        this.entity = entity;
        this.localColumns = localColumns;
        this.foreignColumns = foreignColumns;
    }

    public RelationalPath<?> getEntity() {
        return this.entity;
    }

    public List<? extends Path<?>> getLocalColumns() {
        return this.localColumns;
    }

    public List<String> getForeignColumns() {
        return this.foreignColumns;
    }

    public Predicate on(RelationalPath<E> entity) {
        BooleanBuilder builder = new BooleanBuilder();
        for (int i = 0; i < this.localColumns.size(); ++i) {
            Expression local = (Expression)this.localColumns.get(i);
            PathImpl foreign = new PathImpl(local.getType(), entity, (String)this.foreignColumns.get(i));
            builder.and(ExpressionUtils.eq((Expression)local, (Expression)foreign));
        }
        return builder.getValue();
    }

    public BooleanExpression in(CollectionExpression<?, Tuple> coll) {
        return BooleanOperation.create((Operator)Ops.IN, this.getProjection(), coll);
    }

    public Expression<Tuple> getProjection() {
        if (this.mixin == null) {
            this.mixin = ExpressionUtils.list(Tuple.class, this.localColumns);
        }
        return this.mixin;
    }
}

