/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.sql;

import com.mysema.query.QueryFlag;
import com.mysema.query.QueryMetadata;
import com.mysema.query.QueryModifiers;
import com.mysema.query.sql.SQLSerializer;
import com.mysema.query.sql.SQLServerTemplates;
import com.mysema.query.sql.SQLTemplates;

public class SQLServer2012Templates
extends SQLServerTemplates {
    private String limitOffsetTemplate = "\noffset {1} rows fetch next {0} rows only";
    private String offsetTemplate = "\noffset {0} rows";

    public static SQLTemplates.Builder builder() {
        return new SQLTemplates.Builder(){

            @Override
            protected SQLTemplates build(char escape, boolean quote) {
                return new SQLServer2012Templates(escape, quote);
            }
        };
    }

    public SQLServer2012Templates() {
        this('\\', false);
    }

    public SQLServer2012Templates(boolean quote) {
        this('\\', quote);
    }

    public SQLServer2012Templates(char escape, boolean quote) {
        super(escape, quote);
    }

    @Override
    public void serialize(QueryMetadata metadata, boolean forCountRow, SQLSerializer context) {
        context.serializeForQuery(metadata, forCountRow);
        if (!metadata.getFlags().isEmpty()) {
            context.serialize(QueryFlag.Position.END, metadata.getFlags());
        }
    }

    @Override
    protected void serializeModifiers(QueryMetadata metadata, SQLSerializer context) {
        QueryModifiers mod = metadata.getModifiers();
        if (mod.getLimit() == null) {
            context.handle(this.offsetTemplate, mod.getOffset());
        } else if (mod.getOffset() == null) {
            context.handle(this.limitOffsetTemplate, mod.getLimit(), 0);
        } else {
            context.handle(this.limitOffsetTemplate, mod.getLimit(), mod.getOffset());
        }
    }
}

