/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.sql;

import com.google.common.base.Strings;
import com.mysema.commons.lang.Pair;
import com.mysema.query.JoinExpression;
import com.mysema.query.JoinFlag;
import com.mysema.query.QueryFlag;
import com.mysema.query.QueryMetadata;
import com.mysema.query.sql.RelationalPath;
import com.mysema.query.sql.SQLTemplates;
import com.mysema.query.sql.SerializationContext;
import com.mysema.query.support.Expressions;
import com.mysema.query.support.SerializerBase;
import com.mysema.query.types.Constant;
import com.mysema.query.types.ConstantImpl;
import com.mysema.query.types.Expression;
import com.mysema.query.types.FactoryExpression;
import com.mysema.query.types.Operation;
import com.mysema.query.types.Operator;
import com.mysema.query.types.Ops;
import com.mysema.query.types.Order;
import com.mysema.query.types.OrderSpecifier;
import com.mysema.query.types.ParamExpression;
import com.mysema.query.types.Path;
import com.mysema.query.types.Predicate;
import com.mysema.query.types.SubQueryExpression;
import com.mysema.query.types.TemplateExpression;
import com.mysema.query.types.TemplateExpressionImpl;
import com.mysema.query.types.Templates;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;

public class SQLSerializer
extends SerializerBase<SQLSerializer> {
    private final SerializationContext context = new SerializationContext(){

        @Override
        public void serialize(QueryMetadata metadata, boolean forCountRow) {
            SQLSerializer.this.serializeForQuery(metadata, forCountRow);
        }

        @Override
        public SerializationContext append(String str) {
            SQLSerializer.this.append(new String[]{str});
            return this;
        }

        @Override
        public void handle(String template, Object ... args) {
            Expression[] exprs = new Expression[args.length];
            for (int i = 0; i < args.length; ++i) {
                exprs[i] = new ConstantImpl(args[i]);
            }
            SQLSerializer.this.handle(TemplateExpressionImpl.create(Object.class, (String)template, (Expression[])exprs));
        }
    };
    private static final String COMMA = ", ";
    private final List<Path<?>> constantPaths = new ArrayList();
    private final List<Object> constants = new ArrayList<Object>();
    private final boolean dml;
    protected Stage stage = Stage.SELECT;
    private boolean skipParent;
    private boolean dmlWithSchema;
    private RelationalPath<?> entity;
    private final SQLTemplates templates;
    private boolean inUnion = false;

    public SQLSerializer(SQLTemplates templates) {
        this(templates, false, false);
    }

    public SQLSerializer(SQLTemplates templates, boolean dml) {
        this(templates, dml, false);
    }

    public SQLSerializer(SQLTemplates templates, boolean dml, boolean dry) {
        super((Templates)templates, dry);
        this.templates = templates;
        this.dml = dml;
    }

    private void appendAsColumnName(Path<?> path) {
        String column = path.getMetadata().getExpression().toString();
        this.append(new String[]{this.templates.quoteIdentifier(column)});
    }

    private void appendAsSchemaName(RelationalPath<?> path) {
        String schema = path.getSchemaName();
        this.append(new String[]{this.templates.quoteIdentifier(schema)});
    }

    private void appendAsTableName(RelationalPath<?> path) {
        String table = path.getTableName();
        this.append(new String[]{this.templates.quoteIdentifier(table)});
    }

    public List<Object> getConstants() {
        return this.constants;
    }

    public List<Path<?>> getConstantPaths() {
        return this.constantPaths;
    }

    private List<Expression<?>> getIdentifierColumns(List<JoinExpression> joins) {
        JoinExpression join = joins.get(0);
        RelationalPath path = (RelationalPath)join.getTarget();
        if (path.getPrimaryKey() != null) {
            return path.getPrimaryKey().getLocalColumns();
        }
        return path.getColumns();
    }

    protected SQLTemplates getTemplates() {
        return this.templates;
    }

    private void handleJoinTarget(JoinExpression je) {
        RelationalPath pe;
        if (je.getTarget() instanceof RelationalPath && this.templates.isSupportsAlias() && (pe = (RelationalPath)je.getTarget()).getMetadata().getParent() == null) {
            if (this.templates.isPrintSchema()) {
                this.appendAsSchemaName(pe);
                this.append(new String[]{"."});
            }
            this.appendAsTableName(pe);
            this.append(new String[]{this.templates.getTableAlias()});
        }
        this.handle(je.getTarget());
    }

    public void serialize(QueryMetadata metadata, boolean forCountRow) {
        this.templates.serialize(metadata, forCountRow, this.context);
    }

    private void serializeForQuery(QueryMetadata metadata, boolean forCountRow) {
        List select = metadata.getProjection();
        List joins = metadata.getJoins();
        Predicate where = metadata.getWhere();
        List groupBy = metadata.getGroupBy();
        Predicate having = metadata.getHaving();
        List orderBy = metadata.getOrderBy();
        Set flags = metadata.getFlags();
        ArrayList<Expression> sqlSelect = new ArrayList<Expression>();
        for (Expression selectExpr : select) {
            if (selectExpr instanceof FactoryExpression) {
                sqlSelect.addAll(((FactoryExpression)selectExpr).getArgs());
                continue;
            }
            sqlSelect.add(selectExpr);
        }
        this.serialize(QueryFlag.Position.START, flags);
        Stage oldStage = this.stage;
        this.stage = Stage.SELECT;
        if (forCountRow) {
            this.append(new String[]{this.templates.getSelect()});
            this.serialize(QueryFlag.Position.AFTER_SELECT, flags);
            if (!metadata.isDistinct()) {
                this.append(new String[]{this.templates.getCountStar()});
            } else {
                this.append(new String[]{this.templates.getDistinctCountStart()});
                if (sqlSelect.isEmpty()) {
                    this.handle(COMMA, this.getIdentifierColumns(joins));
                } else {
                    this.handle(COMMA, sqlSelect);
                }
                this.append(new String[]{this.templates.getDistinctCountEnd()});
            }
        } else if (!sqlSelect.isEmpty()) {
            if (!metadata.isDistinct()) {
                this.append(new String[]{this.templates.getSelect()});
            } else {
                this.append(new String[]{this.templates.getSelectDistinct()});
            }
            this.serialize(QueryFlag.Position.AFTER_SELECT, flags);
            this.handle(COMMA, sqlSelect);
        }
        this.serialize(QueryFlag.Position.AFTER_PROJECTION, flags);
        this.stage = Stage.FROM;
        this.serializeSources(joins);
        this.stage = Stage.WHERE;
        this.serialize(QueryFlag.Position.BEFORE_FILTERS, flags);
        if (where != null) {
            ((SQLSerializer)this.append(new String[]{this.templates.getWhere()})).handle((Expression)where);
            this.serialize(QueryFlag.Position.AFTER_FILTERS, flags);
        }
        this.stage = Stage.GROUP_BY;
        this.serialize(QueryFlag.Position.BEFORE_GROUP_BY, flags);
        if (!groupBy.isEmpty()) {
            ((SQLSerializer)this.append(new String[]{this.templates.getGroupBy()})).handle(COMMA, groupBy);
            this.serialize(QueryFlag.Position.AFTER_GROUP_BY, flags);
        }
        this.stage = Stage.HAVING;
        this.serialize(QueryFlag.Position.BEFORE_HAVING, flags);
        if (having != null) {
            ((SQLSerializer)this.append(new String[]{this.templates.getHaving()})).handle((Expression)having);
            this.serialize(QueryFlag.Position.AFTER_HAVING, flags);
        }
        this.stage = Stage.ORDER_BY;
        this.serialize(QueryFlag.Position.BEFORE_ORDER, flags);
        if (!orderBy.isEmpty() && !forCountRow) {
            this.append(new String[]{this.templates.getOrderBy()});
            boolean first = true;
            for (OrderSpecifier os : orderBy) {
                if (!first) {
                    this.append(new String[]{COMMA});
                }
                this.handle(os.getTarget());
                this.append(new String[]{os.getOrder() == Order.ASC ? this.templates.getAsc() : this.templates.getDesc()});
                first = false;
            }
            this.serialize(QueryFlag.Position.AFTER_ORDER, flags);
        }
        if (!forCountRow && metadata.getModifiers().isRestricting() && !joins.isEmpty()) {
            this.templates.serializeModifiers(metadata, this.context);
        }
        this.serialize(QueryFlag.Position.END, flags);
        this.stage = oldStage;
    }

    public void serializeForDelete(QueryMetadata metadata, RelationalPath<?> entity) {
        this.entity = entity;
        this.serialize(QueryFlag.Position.START, metadata.getFlags());
        if (!this.serialize(QueryFlag.Position.START_OVERRIDE, metadata.getFlags())) {
            this.append(new String[]{this.templates.getDeleteFrom()});
        }
        this.dmlWithSchema = true;
        this.handle((Expression)entity);
        this.dmlWithSchema = false;
        if (metadata.getWhere() != null) {
            ((SQLSerializer)this.append(new String[]{this.templates.getWhere()})).handle((Expression)metadata.getWhere());
        }
        this.serialize(QueryFlag.Position.END, metadata.getFlags());
    }

    public void serializeForMerge(QueryMetadata metadata, RelationalPath<?> entity, List<Path<?>> keys, List<Path<?>> columns, List<Expression<?>> values, @Nullable SubQueryExpression<?> subQuery) {
        this.entity = entity;
        this.serialize(QueryFlag.Position.START, metadata.getFlags());
        if (!this.serialize(QueryFlag.Position.START_OVERRIDE, metadata.getFlags())) {
            this.append(new String[]{this.templates.getMergeInto()});
        }
        this.dmlWithSchema = true;
        this.handle((Expression)entity);
        this.dmlWithSchema = false;
        this.append(new String[]{" "});
        if (!columns.isEmpty()) {
            this.skipParent = true;
            ((SQLSerializer)((SQLSerializer)this.append(new String[]{"("})).handle(COMMA, columns)).append(new String[]{") "});
            this.skipParent = false;
        }
        if (!keys.isEmpty()) {
            this.append(new String[]{this.templates.getKey()});
            this.skipParent = true;
            ((SQLSerializer)((SQLSerializer)this.append(new String[]{"("})).handle(COMMA, keys)).append(new String[]{") "});
            this.skipParent = false;
        }
        if (subQuery != null) {
            this.append(new String[]{"\n"});
            this.serialize(subQuery.getMetadata(), false);
        } else {
            for (int i = 0; i < columns.size(); ++i) {
                if (!(values.get(i) instanceof Constant)) continue;
                this.constantPaths.add(columns.get(i));
            }
            this.append(new String[]{this.templates.getValues()});
            ((SQLSerializer)((SQLSerializer)this.append(new String[]{"("})).handle(COMMA, values)).append(new String[]{") "});
        }
        this.serialize(QueryFlag.Position.END, metadata.getFlags());
    }

    public void serializeForInsert(QueryMetadata metadata, RelationalPath<?> entity, List<Path<?>> columns, List<Expression<?>> values, @Nullable SubQueryExpression<?> subQuery) {
        this.entity = entity;
        this.serialize(QueryFlag.Position.START, metadata.getFlags());
        if (!this.serialize(QueryFlag.Position.START_OVERRIDE, metadata.getFlags())) {
            this.append(new String[]{this.templates.getInsertInto()});
        }
        this.dmlWithSchema = true;
        this.handle((Expression)entity);
        this.dmlWithSchema = false;
        if (!columns.isEmpty()) {
            this.append(new String[]{" ("});
            this.skipParent = true;
            this.handle(COMMA, columns);
            this.skipParent = false;
            this.append(new String[]{")"});
        }
        if (subQuery != null) {
            this.append(new String[]{"\n"});
            this.serialize(subQuery.getMetadata(), false);
        } else {
            for (int i = 0; i < columns.size(); ++i) {
                if (!(values.get(i) instanceof Constant)) continue;
                this.constantPaths.add(columns.get(i));
            }
            this.append(new String[]{this.templates.getValues()});
            this.append(new String[]{"("});
            this.handle(COMMA, values);
            this.append(new String[]{")"});
        }
        this.serialize(QueryFlag.Position.END, metadata.getFlags());
    }

    public void serializeForUpdate(QueryMetadata metadata, RelationalPath<?> entity, List<Pair<Path<?>, Expression<?>>> updates) {
        this.entity = entity;
        this.serialize(QueryFlag.Position.START, metadata.getFlags());
        if (!this.serialize(QueryFlag.Position.START_OVERRIDE, metadata.getFlags())) {
            this.append(new String[]{this.templates.getUpdate()});
        }
        this.dmlWithSchema = true;
        this.handle((Expression)entity);
        this.dmlWithSchema = false;
        this.append(new String[]{"\n"});
        this.append(new String[]{this.templates.getSet()});
        boolean first = true;
        this.skipParent = true;
        for (Pair<Path<?>, Expression<?>> update : updates) {
            if (!first) {
                this.append(new String[]{COMMA});
            }
            this.handle((Expression)update.getFirst());
            this.append(new String[]{" = "});
            if (update.getSecond() instanceof Constant) {
                this.constantPaths.add((Path<?>)update.getFirst());
            }
            this.handle((Expression)update.getSecond());
            first = false;
        }
        this.skipParent = false;
        if (metadata.getWhere() != null) {
            ((SQLSerializer)this.append(new String[]{this.templates.getWhere()})).handle((Expression)metadata.getWhere());
        }
        this.serialize(QueryFlag.Position.END, metadata.getFlags());
    }

    private void serializeSources(List<JoinExpression> joins) {
        if (joins.isEmpty()) {
            String dummyTable = this.templates.getDummyTable();
            if (!Strings.isNullOrEmpty((String)dummyTable)) {
                this.append(new String[]{this.templates.getFrom()});
                this.append(new String[]{dummyTable});
            }
        } else {
            this.append(new String[]{this.templates.getFrom()});
            for (int i = 0; i < joins.size(); ++i) {
                JoinExpression je = joins.get(i);
                this.serialize(JoinFlag.Position.START, je.getFlags());
                if (!this.serialize(JoinFlag.Position.OVERRIDE, je.getFlags()) && i > 0) {
                    this.append(new String[]{this.templates.getJoinSymbol(je.getType())});
                }
                this.serialize(JoinFlag.Position.BEFORE_TARGET, je.getFlags());
                this.handleJoinTarget(je);
                this.serialize(JoinFlag.Position.BEFORE_CONDITION, je.getFlags());
                if (je.getCondition() != null) {
                    ((SQLSerializer)this.append(new String[]{this.templates.getOn()})).handle((Expression)je.getCondition());
                }
                this.serialize(JoinFlag.Position.END, je.getFlags());
            }
        }
    }

    public void serializeUnion(SubQueryExpression[] sqs, QueryMetadata metadata, boolean unionAll) {
        boolean oldInUnion = this.inUnion;
        this.inUnion = true;
        this.handle(unionAll ? this.templates.getUnionAll() : this.templates.getUnion(), Arrays.asList(sqs));
        this.inUnion = oldInUnion;
        if (!metadata.getOrderBy().isEmpty()) {
            this.append(new String[]{this.templates.getOrderBy()});
            boolean first = true;
            this.skipParent = true;
            for (OrderSpecifier os : metadata.getOrderBy()) {
                if (!first) {
                    this.append(new String[]{COMMA});
                }
                this.handle(os.getTarget());
                this.append(new String[]{os.getOrder() == Order.ASC ? this.templates.getAsc() : this.templates.getDesc()});
                first = false;
            }
            this.skipParent = false;
        }
    }

    public Void visit(Constant<?> expr, Void context) {
        if (expr.getConstant() instanceof Collection) {
            this.append(new String[]{"("});
            boolean first = true;
            for (Object o : (Collection)expr.getConstant()) {
                if (!first) {
                    this.append(new String[]{COMMA});
                }
                this.append(new String[]{"?"});
                this.constants.add(o);
                if (first && this.constantPaths.size() < this.constants.size()) {
                    this.constantPaths.add(null);
                }
                first = false;
            }
            this.append(new String[]{")"});
            int size = ((Collection)expr.getConstant()).size() - 1;
            Path<?> lastPath = this.constantPaths.get(this.constantPaths.size() - 1);
            for (int i = 0; i < size; ++i) {
                this.constantPaths.add(lastPath);
            }
        } else {
            this.append(new String[]{"?"});
            this.constants.add(expr.getConstant());
            if (this.constantPaths.size() < this.constants.size()) {
                this.constantPaths.add(null);
            }
        }
        return null;
    }

    public Void visit(ParamExpression<?> param, Void context) {
        this.append(new String[]{"?"});
        this.constants.add(param);
        if (this.constantPaths.size() < this.constants.size()) {
            this.constantPaths.add(null);
        }
        return null;
    }

    public Void visit(Path<?> path, Void context) {
        if (this.dml) {
            if (path.equals(this.entity) && path instanceof RelationalPath) {
                if (this.dmlWithSchema && this.templates.isPrintSchema()) {
                    this.appendAsSchemaName((RelationalPath)path);
                    this.append(new String[]{"."});
                }
                this.appendAsTableName((RelationalPath)path);
                return null;
            }
            if (this.entity.equals(path.getMetadata().getParent()) && this.skipParent) {
                this.appendAsColumnName(path);
                return null;
            }
        }
        if (path.getMetadata().getParent() != null && !this.skipParent) {
            this.visit(path.getMetadata().getParent(), context);
            this.append(new String[]{"."});
        }
        this.append(new String[]{this.templates.quoteIdentifier(path.getMetadata().getExpression().toString())});
        return null;
    }

    public Void visit(SubQueryExpression<?> query, Void context) {
        if (this.inUnion) {
            this.serialize(query.getMetadata(), false);
        } else {
            this.append(new String[]{"("});
            this.serialize(query.getMetadata(), false);
            this.append(new String[]{")"});
        }
        return null;
    }

    public Void visit(TemplateExpression<?> expr, Void context) {
        if (expr.getTemplate().toString().toLowerCase().contains("union")) {
            boolean oldInUnion = this.inUnion;
            this.inUnion = true;
            super.visit(expr, context);
            this.inUnion = oldInUnion;
        } else {
            super.visit(expr, context);
        }
        return null;
    }

    protected void visitOperation(Class<?> type, Operator<?> operator, List<? extends Expression<?>> args) {
        if (args.size() == 2 && args.get(0) instanceof Path && args.get(1) instanceof Constant && operator != Ops.STRING_CAST && operator != Ops.NUMCAST && operator != Ops.SUBSTR_1ARG && operator != Ops.CHAR_AT && operator != SQLTemplates.CAST) {
            this.constantPaths.add((Path)args.get(0));
        }
        if (operator.equals((Object)Ops.STRING_CAST)) {
            String typeName = this.templates.getTypeForCast(String.class);
            this.visitOperation(String.class, SQLTemplates.CAST, Arrays.asList(args.get(0), ConstantImpl.create((String)typeName)));
        } else if (operator.equals((Object)Ops.NUMCAST)) {
            Class targetType = (Class)((Constant)args.get(1)).getConstant();
            String typeName = this.templates.getTypeForCast(targetType);
            this.visitOperation(targetType, SQLTemplates.CAST, Arrays.asList(args.get(0), ConstantImpl.create((String)typeName)));
        } else if (operator.equals((Object)Ops.ALIAS)) {
            if (this.stage == Stage.SELECT || this.stage == Stage.FROM) {
                if (args.get(0) instanceof Operation && ((Operation)args.get(0)).getOperator() == SQLTemplates.UNION) {
                    args = Arrays.asList(Expressions.operation(Object.class, (Operator)Ops.WRAPPED, (Expression[])new Expression[]{args.get(0)}), args.get(1));
                }
                super.visitOperation(type, operator, args);
            } else {
                this.handle(args.get(1));
            }
        } else {
            super.visitOperation(type, operator, args);
        }
    }

    protected static enum Stage {
        SELECT,
        FROM,
        WHERE,
        GROUP_BY,
        HAVING,
        ORDER_BY;

    }
}

