/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.sql;

import com.mysema.query.QueryException;
import com.mysema.query.sql.RelationalPath;
import com.mysema.query.types.Expression;
import com.mysema.query.types.FactoryExpression;
import com.mysema.query.types.Path;
import com.mysema.query.types.Projections;
import com.mysema.query.types.QBean;
import com.mysema.util.ReflectionUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;

public final class RelationalPathUtils {
    public static <T> FactoryExpression<T> createProjection(RelationalPath<T> path) {
        if (path.getType().equals(path.getClass())) {
            throw new IllegalArgumentException("RelationalPath based projection can only be used with generated Bean types");
        }
        try {
            path.getType().getConstructor(new Class[0]);
            return RelationalPathUtils.createBeanProjection(path);
        }
        catch (NoSuchMethodException e) {
            return RelationalPathUtils.createConstructorProjection(path);
        }
    }

    private static <T> FactoryExpression<T> createConstructorProjection(RelationalPath<T> path) {
        Expression[] exprs = path.getColumns().toArray(new Expression[path.getColumns().size()]);
        return Projections.constructor((Class)path.getType(), (Expression[])exprs);
    }

    private static <T> FactoryExpression<T> createBeanProjection(RelationalPath<T> path) {
        try {
            HashMap<String, Path> bindings = new HashMap<String, Path>();
            for (Field field : ReflectionUtils.getFields(path.getClass())) {
                if (!Path.class.isAssignableFrom(field.getType()) || Modifier.isStatic(field.getModifiers())) continue;
                field.setAccessible(true);
                Path column = (Path)field.get(path);
                if (!path.equals(column.getMetadata().getParent())) continue;
                bindings.put(field.getName(), column);
            }
            if (bindings.isEmpty()) {
                throw new IllegalArgumentException("No bindings could be derived from " + path);
            }
            return new QBean(path.getType(), true, bindings);
        }
        catch (IllegalAccessException e) {
            throw new QueryException((Throwable)e);
        }
    }

    private RelationalPathUtils() {
    }
}

