/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.sql.oracle;

import com.mysema.query.types.Expr;
import com.mysema.query.types.Visitor;
import com.mysema.query.types.custom.CNumber;
import com.mysema.query.types.expr.ENumber;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;

public class SumOver<A extends Number>
extends ENumber<A> {
    private static final long serialVersionUID = -4130672293308756779L;
    private List<Expr<?>> orderBy = new ArrayList();
    @Nullable
    private Expr<?> partitionBy;
    private final Expr<A> target;

    public SumOver(Expr<A> expr) {
        super(expr.getType());
        this.target = expr;
    }

    public void accept(Visitor v) {
        ArrayList args = new ArrayList();
        StringBuilder builder = new StringBuilder();
        builder.append("sum({0}) over (");
        args.add(this.target);
        if (this.partitionBy != null) {
            builder.append("partition by {1}");
            args.add(this.partitionBy);
        }
        if (!this.orderBy.isEmpty()) {
            if (this.partitionBy != null) {
                builder.append(" ");
            }
            builder.append("order by ");
            boolean first = true;
            for (Expr<?> expr : this.orderBy) {
                if (!first) {
                    builder.append(", ");
                }
                builder.append("{" + args.size() + "}");
                args.add(expr);
                first = false;
            }
        }
        builder.append(")");
        ENumber expr = CNumber.create((Class)this.target.getType(), (String)builder.toString(), (Expr[])args.toArray(new Expr[args.size()]));
        expr.accept(v);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof SumOver) {
            SumOver so = (SumOver)((Object)o);
            return so.target.equals(this.target) && so.partitionBy.equals(this.partitionBy) && ((Object)so.orderBy).equals(this.orderBy);
        }
        return false;
    }

    public int hashCode() {
        return this.target.hashCode();
    }

    public SumOver<A> order(Expr<?> ... orderBy) {
        this.orderBy.addAll(Arrays.asList(orderBy));
        return this;
    }

    public SumOver<A> partition(Expr<?> partitionBy) {
        this.partitionBy = partitionBy;
        return this;
    }
}

