/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.sql;

import com.mysema.codegen.CodeWriter;
import com.mysema.codegen.model.Type;
import com.mysema.query.codegen.EntitySerializer;
import com.mysema.query.codegen.EntityType;
import com.mysema.query.codegen.SerializerConfig;
import com.mysema.query.codegen.TypeMappings;
import com.mysema.query.sql.NamingStrategy;
import com.mysema.query.sql.Table;
import com.mysema.query.sql.support.ForeignKeyData;
import com.mysema.query.sql.support.InverseForeignKeyData;
import com.mysema.query.sql.support.KeyData;
import com.mysema.query.sql.support.PrimaryKeyData;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;

public class MetaDataSerializer
extends EntitySerializer {
    private final String namePrefix;
    private final NamingStrategy namingStrategy;

    public MetaDataSerializer(String namePrefix, NamingStrategy namingStrategy) {
        super(new TypeMappings(), Collections.emptyList());
        this.namePrefix = namePrefix;
        this.namingStrategy = namingStrategy;
    }

    protected void introDefaultInstance(CodeWriter writer, EntityType entityType) throws IOException {
        String variableName = this.namingStrategy.getDefaultVariableName(this.namePrefix, entityType);
        String alias = this.namingStrategy.getDefaultAlias(this.namePrefix, entityType);
        String queryType = this.typeMappings.getPathType((Type)entityType, entityType, true);
        writer.publicStaticFinal(queryType, variableName, "new " + queryType + "(\"" + alias + "\")");
    }

    protected void introImports(CodeWriter writer, SerializerConfig config, EntityType model) throws IOException {
        super.introImports(writer, config, model);
        writer.imports(new Package[]{Table.class.getPackage()});
    }

    protected void serializeProperties(EntityType model, SerializerConfig config, CodeWriter writer) throws IOException {
        Collection inverseForeignKeys;
        Collection foreignKeys;
        super.serializeProperties(model, config, writer);
        Collection primaryKeys = (Collection)model.getData().get(PrimaryKeyData.class);
        if (primaryKeys != null) {
            this.serializePrimaryKeys(model, writer, primaryKeys);
        }
        if ((foreignKeys = (Collection)model.getData().get(ForeignKeyData.class)) != null) {
            this.serializeForeignKeys(model, writer, foreignKeys, false);
        }
        if ((inverseForeignKeys = (Collection)model.getData().get(InverseForeignKeyData.class)) != null) {
            this.serializeForeignKeys(model, writer, inverseForeignKeys, true);
        }
    }

    protected void serializePrimaryKeys(EntityType model, CodeWriter writer, Collection<PrimaryKeyData> primaryKeys) throws IOException {
        String queryType = this.typeMappings.getPathType((Type)model, model, true);
        for (PrimaryKeyData primaryKey : primaryKeys) {
            String fieldName = this.namingStrategy.getPropertyNameForPrimaryKey(primaryKey.getName(), model);
            StringBuilder value = new StringBuilder("new PrimaryKey<" + queryType + ">(this, ");
            boolean first = true;
            for (String column : primaryKey.getColumns()) {
                if (!first) {
                    value.append(", ");
                }
                value.append(this.namingStrategy.getPropertyName(column, this.namePrefix, model));
                first = false;
            }
            value.append(")");
            writer.publicFinal("PrimaryKey<" + queryType + ">", fieldName, value.toString());
        }
    }

    protected void serializeForeignKeys(EntityType model, CodeWriter writer, Collection<? extends KeyData> foreignKeys, boolean inverse) throws IOException {
        for (KeyData keyData : foreignKeys) {
            String fieldName = inverse ? this.namingStrategy.getPropertyNameForInverseForeignKey(keyData.getName(), model) : this.namingStrategy.getPropertyNameForForeignKey(keyData.getName(), model);
            String foreignType = this.namingStrategy.getClassName(this.namePrefix, keyData.getTable());
            StringBuilder value = new StringBuilder();
            value.append("new ForeignKey<" + foreignType + ">(this, ");
            if (keyData.getForeignColumns().size() == 1) {
                value.append(this.namingStrategy.getPropertyName(keyData.getForeignColumns().get(0), this.namePrefix, model));
                value.append(", \"" + keyData.getParentColumns().get(0) + "\"");
            } else {
                StringBuilder local = new StringBuilder();
                StringBuilder foreign = new StringBuilder();
                for (int i = 0; i < keyData.getForeignColumns().size(); ++i) {
                    if (i > 0) {
                        local.append(", ");
                        foreign.append(", ");
                    }
                    local.append(this.namingStrategy.getPropertyName(keyData.getForeignColumns().get(0), this.namePrefix, model));
                    foreign.append("\"" + keyData.getParentColumns().get(0) + "\"");
                }
                value.append("Arrays.asList(" + local + "), Arrays.asList(" + foreign + ")");
            }
            value.append(")");
            writer.publicFinal("ForeignKey<" + foreignType + ">", fieldName, value.toString());
        }
    }
}

