/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.sql;

import com.mysema.query.codegen.EntityType;
import com.mysema.query.sql.NamingStrategy;
import com.mysema.query.sql.Table;
import com.mysema.util.JavaSyntaxUtils;
import java.util.Locale;

public class DefaultNamingStrategy
implements NamingStrategy {
    private final String reservedSuffix;

    public DefaultNamingStrategy() {
        this("Col");
    }

    public DefaultNamingStrategy(String reservedSuffix) {
        this.reservedSuffix = reservedSuffix;
    }

    @Override
    public String getClassName(String namePrefix, String tableName) {
        if (tableName.length() > 1) {
            return namePrefix + tableName.substring(0, 1).toUpperCase(Locale.ENGLISH) + this.toCamelCase(tableName.substring(1));
        }
        return namePrefix + tableName.toUpperCase(Locale.ENGLISH);
    }

    @Override
    public String getDefaultAlias(String namePrefix, EntityType entityType) {
        return ((Table)entityType.getAnnotation(Table.class)).value();
    }

    @Override
    public String getDefaultVariableName(String namePrefix, EntityType entityType) {
        return this.toCamelCase(((Table)entityType.getAnnotation(Table.class)).value());
    }

    @Override
    public String getPropertyName(String columnName, String namePrefix, EntityType entityType) {
        String propertyName = columnName.substring(0, 1).toLowerCase(Locale.ENGLISH) + this.toCamelCase(columnName.substring(1));
        if (JavaSyntaxUtils.isReserved((String)propertyName)) {
            propertyName = propertyName + this.reservedSuffix;
        }
        return propertyName;
    }

    @Override
    public String getPropertyNameForForeignKey(String foreignKeyName, EntityType entityType) {
        if (foreignKeyName.toLowerCase().startsWith("fk_")) {
            foreignKeyName = foreignKeyName.substring(3) + "_fk";
        }
        if (foreignKeyName.length() > 1) {
            String propertyName = foreignKeyName.substring(0, 1).toLowerCase(Locale.ENGLISH) + this.toCamelCase(foreignKeyName.substring(1));
            if (JavaSyntaxUtils.isReserved((String)propertyName)) {
                propertyName = propertyName + this.reservedSuffix;
            }
            return propertyName;
        }
        return foreignKeyName.toLowerCase(Locale.ENGLISH);
    }

    @Override
    public String getPropertyNameForInverseForeignKey(String foreignKeyName, EntityType entityType) {
        return "_" + this.getPropertyNameForForeignKey(foreignKeyName, entityType);
    }

    @Override
    public String getPropertyNameForPrimaryKey(String primaryKeyName, EntityType entityType) {
        if (primaryKeyName.toLowerCase().startsWith("pk_")) {
            primaryKeyName = primaryKeyName.substring(3) + "_pk";
        }
        if (primaryKeyName.length() > 1) {
            String propertyName = primaryKeyName.substring(0, 1).toLowerCase(Locale.ENGLISH) + this.toCamelCase(primaryKeyName.substring(1));
            if (JavaSyntaxUtils.isReserved((String)propertyName)) {
                propertyName = propertyName + this.reservedSuffix;
            }
            return propertyName;
        }
        return primaryKeyName.toLowerCase(Locale.ENGLISH);
    }

    @Override
    public String normalizeColumnName(String columnName) {
        return columnName;
    }

    @Override
    public String normalizeTableName(String tableName) {
        return tableName;
    }

    protected String toCamelCase(String str) {
        StringBuilder builder = new StringBuilder(str.length());
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) == '_') {
                if (++i >= str.length()) continue;
                builder.append(Character.toUpperCase(str.charAt(i)));
                continue;
            }
            builder.append(Character.toLowerCase(str.charAt(i)));
        }
        return builder.toString();
    }
}

