/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.sql;

import com.mysema.commons.lang.CloseableIterator;
import com.mysema.commons.lang.IteratorAdapter;
import com.mysema.query.DefaultQueryMetadata;
import com.mysema.query.JoinExpression;
import com.mysema.query.JoinFlag;
import com.mysema.query.QueryException;
import com.mysema.query.QueryFlag;
import com.mysema.query.QueryMetadata;
import com.mysema.query.QueryModifiers;
import com.mysema.query.SearchResults;
import com.mysema.query.sql.Configuration;
import com.mysema.query.sql.ForeignKey;
import com.mysema.query.sql.SQLResultIterator;
import com.mysema.query.sql.SQLSerializer;
import com.mysema.query.sql.Union;
import com.mysema.query.support.ProjectableQuery;
import com.mysema.query.support.QueryMixin;
import com.mysema.query.types.EConstructor;
import com.mysema.query.types.Expr;
import com.mysema.query.types.OrderSpecifier;
import com.mysema.query.types.Param;
import com.mysema.query.types.ParamNotSetException;
import com.mysema.query.types.Path;
import com.mysema.query.types.SubQuery;
import com.mysema.query.types.custom.CSimple;
import com.mysema.query.types.expr.EBoolean;
import com.mysema.query.types.path.PEntity;
import com.mysema.query.types.query.ListSubQuery;
import com.mysema.util.ResultSetAdapter;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressWarnings(value={"SQL_PREPARED_STATEMENT_GENERATED_FROM_NONCONSTANT_STRING"})
public abstract class AbstractSQLQuery<Q extends AbstractSQLQuery<Q>>
extends ProjectableQuery<Q> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractSQLQuery.class);
    @Nullable
    private final Connection conn;
    @Nullable
    private List<Object> constants;
    @Nullable
    private SubQuery<?>[] union;
    private final Configuration configuration;

    public AbstractSQLQuery(@Nullable Connection conn, Configuration configuration) {
        this(conn, configuration, (QueryMetadata)new DefaultQueryMetadata());
    }

    public AbstractSQLQuery(@Nullable Connection conn, Configuration configuration, QueryMetadata metadata) {
        super(new QueryMixin(metadata));
        this.queryMixin.setSelf((Object)this);
        this.conn = conn;
        this.configuration = configuration;
    }

    protected Q addJoinFlag(String flag) {
        List joins = this.queryMixin.getMetadata().getJoins();
        ((JoinExpression)joins.get(joins.size() - 1)).addFlag(new JoinFlag(flag));
        return (Q)((Object)this);
    }

    protected Q addFlag(QueryFlag.Position position, String prefix, Expr<?> expr) {
        Expr flag = CSimple.create((Class)expr.getType(), (String)(prefix + "{0}"), (Expr[])new Expr[]{expr});
        return (Q)((Object)((AbstractSQLQuery)((Object)this.queryMixin.addFlag(new QueryFlag(position, flag)))));
    }

    protected Q addFlag(QueryFlag.Position position, String flag) {
        return (Q)((Object)((AbstractSQLQuery)((Object)this.queryMixin.addFlag(new QueryFlag(position, flag)))));
    }

    protected Q addFlag(QueryFlag.Position position, Expr<?> flag) {
        return (Q)((Object)((AbstractSQLQuery)((Object)this.queryMixin.addFlag(new QueryFlag(position, flag)))));
    }

    protected String buildQueryString(boolean forCountRow) {
        SQLSerializer serializer = this.createSerializer();
        if (this.union != null) {
            serializer.serializeUnion(this.union, this.queryMixin.getMetadata().getOrderBy());
        } else {
            serializer.serialize(this.queryMixin.getMetadata(), forCountRow);
        }
        this.constants = serializer.getConstants();
        return serializer.toString();
    }

    public long count() {
        try {
            return this.unsafeCount();
        }
        catch (SQLException e) {
            String error = "Caught " + e.getClass().getName();
            logger.error(error, (Throwable)e);
            throw new QueryException(e.getMessage(), (Throwable)e);
        }
    }

    protected SQLSerializer createSerializer() {
        return new SQLSerializer(this.configuration.getTemplates());
    }

    public Q from(Expr<?> ... args) {
        return (Q)((Object)((AbstractSQLQuery)((Object)this.queryMixin.from(args))));
    }

    public Q fullJoin(PEntity<?> target) {
        return (Q)((Object)((AbstractSQLQuery)((Object)this.queryMixin.fullJoin(target))));
    }

    public Q fullJoin(SubQuery<?> target, Path<?> alias) {
        return (Q)((Object)((AbstractSQLQuery)((Object)this.queryMixin.fullJoin(target, alias))));
    }

    public <E> Q fullJoin(ForeignKey<E> key, PEntity<E> entity) {
        return ((AbstractSQLQuery)((Object)this.queryMixin.fullJoin(entity))).on(key.on(entity));
    }

    public Q innerJoin(PEntity<?> target) {
        return (Q)((Object)((AbstractSQLQuery)((Object)this.queryMixin.innerJoin(target))));
    }

    public Q innerJoin(SubQuery<?> target, Path<?> alias) {
        return (Q)((Object)((AbstractSQLQuery)((Object)this.queryMixin.innerJoin(target, alias))));
    }

    public <E> Q innerJoin(ForeignKey<E> key, PEntity<E> entity) {
        return ((AbstractSQLQuery)((Object)this.queryMixin.innerJoin(entity))).on(key.on(entity));
    }

    public Q join(PEntity<?> target) {
        return (Q)((Object)((AbstractSQLQuery)((Object)this.queryMixin.join(target))));
    }

    public Q join(SubQuery<?> target, Path<?> alias) {
        return (Q)((Object)((AbstractSQLQuery)((Object)this.queryMixin.join(target, alias))));
    }

    public <E> Q join(ForeignKey<E> key, PEntity<E> entity) {
        return ((AbstractSQLQuery)((Object)this.queryMixin.join(entity))).on(key.on(entity));
    }

    public Q leftJoin(PEntity<?> target) {
        return (Q)((Object)((AbstractSQLQuery)((Object)this.queryMixin.leftJoin(target))));
    }

    public Q leftJoin(SubQuery<?> target, Path<?> alias) {
        return (Q)((Object)((AbstractSQLQuery)((Object)this.queryMixin.leftJoin(target, alias))));
    }

    public <E> Q leftJoin(ForeignKey<E> key, PEntity<E> entity) {
        return ((AbstractSQLQuery)((Object)this.queryMixin.leftJoin(entity))).on(key.on(entity));
    }

    public Q rightJoin(PEntity<?> target) {
        return (Q)((Object)((AbstractSQLQuery)((Object)this.queryMixin.rightJoin(target))));
    }

    public Q rightJoin(SubQuery<?> target, Path<?> alias) {
        return (Q)((Object)((AbstractSQLQuery)((Object)this.queryMixin.rightJoin(target, alias))));
    }

    public <E> Q rightJoin(ForeignKey<E> key, PEntity<E> entity) {
        return ((AbstractSQLQuery)((Object)this.queryMixin.rightJoin(entity))).on(key.on(entity));
    }

    @Nullable
    private <T> T get(ResultSet rs, int i, Class<T> type) {
        try {
            return this.configuration.get(rs, i, type);
        }
        catch (SQLException e) {
            throw new QueryException((Throwable)e);
        }
    }

    public QueryMetadata getMetadata() {
        return this.queryMixin.getMetadata();
    }

    public ResultSet getResults(Expr<?> ... exprs) {
        this.queryMixin.addToProjection(exprs);
        String queryString = this.buildQueryString(false);
        logger.debug("query : {}", (Object)queryString);
        try {
            final PreparedStatement stmt = this.conn.prepareStatement(queryString);
            this.setParameters(stmt, this.constants, this.getMetadata().getParams());
            ResultSet rs = stmt.executeQuery();
            ResultSetAdapter resultSetAdapter = new ResultSetAdapter(rs){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void close() throws SQLException {
                    try {
                        super.close();
                    }
                    finally {
                        stmt.close();
                    }
                }
            };
            return resultSetAdapter;
        }
        catch (SQLException e) {
            throw new QueryException((Throwable)e);
        }
        finally {
            this.reset();
        }
    }

    private <RT> UnionBuilder<RT> innerUnion(SubQuery<?> ... sq) {
        if (!this.queryMixin.getMetadata().getJoins().isEmpty()) {
            throw new IllegalArgumentException("Don't mix union and from");
        }
        this.union = sq;
        return new UnionBuilder();
    }

    protected Configuration getConfiguration() {
        return this.configuration;
    }

    public CloseableIterator<Object[]> iterate(Expr<?>[] args) {
        this.queryMixin.addToProjection(args);
        return this.iterateMultiple();
    }

    public <RT> CloseableIterator<RT> iterate(Expr<RT> expr) {
        this.queryMixin.addToProjection(new Expr[]{expr});
        return this.iterateSingle(expr);
    }

    private CloseableIterator<Object[]> iterateMultiple() {
        String queryString = this.buildQueryString(false);
        logger.debug("query : {}", (Object)queryString);
        try {
            PreparedStatement stmt = this.conn.prepareStatement(queryString);
            final List projection = this.getMetadata().getProjection();
            this.setParameters(stmt, this.constants, this.getMetadata().getParams());
            ResultSet rs = stmt.executeQuery();
            SQLResultIterator<Object[]> sQLResultIterator = new SQLResultIterator<Object[]>((Statement)stmt, rs){

                @Override
                protected Object[] produceNext(ResultSet rs) {
                    try {
                        ArrayList<Object> objects = new ArrayList<Object>(projection.size());
                        int index = 0;
                        for (int i = 0; i < projection.size(); ++i) {
                            Expr expr = (Expr)projection.get(i);
                            if (expr instanceof EConstructor) {
                                objects.add(AbstractSQLQuery.this.newInstance((EConstructor)expr, rs, index));
                                index += ((EConstructor)expr).getArgs().size();
                                continue;
                            }
                            if (expr.getType().isArray()) {
                                for (int j = index; j < rs.getMetaData().getColumnCount(); ++j) {
                                    objects.add(AbstractSQLQuery.this.get(rs, index++ + 1, Object.class));
                                }
                                i = objects.size();
                                continue;
                            }
                            objects.add(AbstractSQLQuery.this.get(rs, index++ + 1, expr.getType()));
                        }
                        return objects.toArray();
                    }
                    catch (InstantiationException e) {
                        this.close();
                        throw new QueryException((Throwable)e);
                    }
                    catch (IllegalAccessException e) {
                        this.close();
                        throw new QueryException((Throwable)e);
                    }
                    catch (InvocationTargetException e) {
                        this.close();
                        throw new QueryException((Throwable)e);
                    }
                    catch (SQLException e) {
                        this.close();
                        throw new QueryException((Throwable)e);
                    }
                }
            };
            return sQLResultIterator;
        }
        catch (SQLException e) {
            throw new QueryException((Throwable)e);
        }
        finally {
            this.reset();
        }
    }

    private <RT> CloseableIterator<RT> iterateSingle(final @Nullable Expr<RT> expr) {
        String queryString = this.buildQueryString(false);
        logger.debug("query : {}", (Object)queryString);
        try {
            PreparedStatement stmt = this.conn.prepareStatement(queryString);
            this.setParameters(stmt, this.constants, this.getMetadata().getParams());
            ResultSet rs = stmt.executeQuery();
            SQLResultIterator sQLResultIterator = new SQLResultIterator<RT>(stmt, rs){

                @Override
                public RT produceNext(ResultSet rs) {
                    try {
                        if (expr == null) {
                            return rs.getObject(1);
                        }
                        if (expr instanceof EConstructor) {
                            return AbstractSQLQuery.this.newInstance((EConstructor)expr, rs, 0);
                        }
                        if (expr.getType().isArray()) {
                            Object[] rv = new Object[rs.getMetaData().getColumnCount()];
                            for (int i = 0; i < rv.length; ++i) {
                                rv[i] = rs.getObject(i + 1);
                            }
                            return rv;
                        }
                        return AbstractSQLQuery.this.get(rs, 1, expr.getType());
                    }
                    catch (IllegalAccessException e) {
                        this.close();
                        throw new QueryException((Throwable)e);
                    }
                    catch (InvocationTargetException e) {
                        this.close();
                        throw new QueryException((Throwable)e);
                    }
                    catch (InstantiationException e) {
                        this.close();
                        throw new QueryException((Throwable)e);
                    }
                    catch (SQLException e) {
                        this.close();
                        throw new QueryException((Throwable)e);
                    }
                }
            };
            return sQLResultIterator;
        }
        catch (SQLException e) {
            throw new QueryException("Caught " + e.getClass().getSimpleName() + " for " + queryString, (Throwable)e);
        }
        finally {
            this.reset();
        }
    }

    public List<Object[]> list(Expr<?>[] args) {
        return IteratorAdapter.asList(this.iterate(args));
    }

    public <RT> List<RT> list(Expr<RT> expr) {
        return IteratorAdapter.asList(this.iterate(expr));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <RT> SearchResults<RT> listResults(Expr<RT> expr) {
        this.queryMixin.addToProjection(new Expr[]{expr});
        long total = this.count();
        try {
            if (total > 0L) {
                QueryModifiers modifiers = this.queryMixin.getMetadata().getModifiers();
                SearchResults searchResults = new SearchResults(this.list(expr), modifiers, total);
                return searchResults;
            }
            SearchResults searchResults = SearchResults.emptyResults();
            return searchResults;
        }
        finally {
            this.reset();
        }
    }

    private <RT> RT newInstance(EConstructor<RT> c, ResultSet rs, int offset) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        Object[] args = new Object[c.getArgs().size()];
        for (int i = 0; i < args.length; ++i) {
            args[i] = this.get(rs, offset + i + 1, ((Expr)c.getArgs().get(i)).getType());
        }
        return (RT)c.newInstance(args);
    }

    public Q on(EBoolean ... conditions) {
        return (Q)((Object)((AbstractSQLQuery)((Object)this.queryMixin.on(conditions))));
    }

    private void reset() {
        this.queryMixin.getMetadata().reset();
        this.constants = null;
    }

    protected void setParameters(PreparedStatement stmt, Collection<?> objects, Map<Param<?>, ?> params) {
        int counter = 1;
        for (Object o : objects) {
            try {
                if (Param.class.isInstance(o)) {
                    if (!params.containsKey(o)) {
                        throw new ParamNotSetException((Param)o);
                    }
                    o = params.get(o);
                }
                counter += this.configuration.set(stmt, counter, o);
            }
            catch (SQLException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }

    public String toString() {
        return this.buildQueryString(false).trim();
    }

    public <RT> UnionBuilder<RT> union(ListSubQuery<RT> ... sq) {
        return this.innerUnion((SubQuery<?>[])sq);
    }

    public <RT> UnionBuilder<RT> union(SubQuery<RT> ... sq) {
        return this.innerUnion(sq);
    }

    public <RT> RT uniqueResult(Expr<RT> expr) {
        List<RT> list = this.list(expr);
        return !list.isEmpty() ? (RT)list.get(0) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long unsafeCount() throws SQLException {
        String queryString = this.buildQueryString(true);
        logger.debug("query : {}", (Object)queryString);
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.conn.prepareStatement(queryString);
            this.setParameters(stmt, this.constants, this.getMetadata().getParams());
            rs = stmt.executeQuery();
            rs.next();
            long l = rs.getLong(1);
            return l;
        }
        catch (SQLException e) {
            throw new QueryException(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
    }

    public class UnionBuilder<RT>
    implements Union<RT> {
        @Override
        public List<RT> list() {
            if (AbstractSQLQuery.this.union[0].getMetadata().getProjection().size() == 1) {
                return IteratorAdapter.asList((Iterator)AbstractSQLQuery.this.iterateSingle(null));
            }
            return IteratorAdapter.asList((Iterator)AbstractSQLQuery.this.iterateMultiple());
        }

        @Override
        public CloseableIterator<RT> iterate() {
            if (AbstractSQLQuery.this.union[0].getMetadata().getProjection().size() == 1) {
                return AbstractSQLQuery.this.iterateSingle(null);
            }
            return AbstractSQLQuery.this.iterateMultiple();
        }

        @Override
        public UnionBuilder<RT> orderBy(OrderSpecifier<?> ... o) {
            AbstractSQLQuery.this.orderBy(o);
            return this;
        }

        public String toString() {
            return AbstractSQLQuery.this.toString();
        }
    }
}

