/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.model.DomainEntityRef;
import com.mypurecloud.sdk.v2.model.ErrorBody;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

public class WhatsAppIntegration
implements Serializable {
    private String id = null;
    private String name = null;
    private String phoneNumber = null;
    private StatusEnum status = null;
    private DomainEntityRef recipient = null;
    private Date dateCreated = null;
    private Date dateModified = null;
    private DomainEntityRef createdBy = null;
    private DomainEntityRef modifiedBy = null;
    private Integer version = null;
    private ActivationStatusCodeEnum activationStatusCode = null;
    private ErrorBody activationErrorInfo = null;
    private String selfUri = null;

    @ApiModelProperty(example="null", required=true, value="A unique Integration Id.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public WhatsAppIntegration name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The name of the WhatsApp integration.")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public WhatsAppIntegration phoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The phone number associated to the whatsApp integration.")
    @JsonProperty(value="phoneNumber")
    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public WhatsAppIntegration status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(example="null", value="The status of the WhatsApp Integration")
    @JsonProperty(value="status")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public WhatsAppIntegration recipient(DomainEntityRef recipient) {
        this.recipient = recipient;
        return this;
    }

    @ApiModelProperty(example="null", value="The recipient associated to the WhatsApp Integration. This recipient is used to associate a flow to an integration")
    @JsonProperty(value="recipient")
    public DomainEntityRef getRecipient() {
        return this.recipient;
    }

    public void setRecipient(DomainEntityRef recipient) {
        this.recipient = recipient;
    }

    public WhatsAppIntegration dateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
        return this;
    }

    @ApiModelProperty(example="null", value="Date this Integration was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ")
    @JsonProperty(value="dateCreated")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    public WhatsAppIntegration dateModified(Date dateModified) {
        this.dateModified = dateModified;
        return this;
    }

    @ApiModelProperty(example="null", value="Date this Integration was last modified. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ")
    @JsonProperty(value="dateModified")
    public Date getDateModified() {
        return this.dateModified;
    }

    public void setDateModified(Date dateModified) {
        this.dateModified = dateModified;
    }

    public WhatsAppIntegration createdBy(DomainEntityRef createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    @ApiModelProperty(example="null", value="User reference that created this Integration")
    @JsonProperty(value="createdBy")
    public DomainEntityRef getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(DomainEntityRef createdBy) {
        this.createdBy = createdBy;
    }

    public WhatsAppIntegration modifiedBy(DomainEntityRef modifiedBy) {
        this.modifiedBy = modifiedBy;
        return this;
    }

    @ApiModelProperty(example="null", value="User reference that last modified this Integration")
    @JsonProperty(value="modifiedBy")
    public DomainEntityRef getModifiedBy() {
        return this.modifiedBy;
    }

    public void setModifiedBy(DomainEntityRef modifiedBy) {
        this.modifiedBy = modifiedBy;
    }

    public WhatsAppIntegration version(Integer version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Version number required for updates.")
    @JsonProperty(value="version")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    @ApiModelProperty(example="null", value="The status code of WhatsApp Integration activation process")
    @JsonProperty(value="activationStatusCode")
    public ActivationStatusCodeEnum getActivationStatusCode() {
        return this.activationStatusCode;
    }

    public WhatsAppIntegration activationErrorInfo(ErrorBody activationErrorInfo) {
        this.activationErrorInfo = activationErrorInfo;
        return this;
    }

    @ApiModelProperty(example="null", value="The error information of WhatsApp Integration activation process")
    @JsonProperty(value="activationErrorInfo")
    public ErrorBody getActivationErrorInfo() {
        return this.activationErrorInfo;
    }

    public void setActivationErrorInfo(ErrorBody activationErrorInfo) {
        this.activationErrorInfo = activationErrorInfo;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WhatsAppIntegration whatsAppIntegration = (WhatsAppIntegration)o;
        return Objects.equals(this.id, whatsAppIntegration.id) && Objects.equals(this.name, whatsAppIntegration.name) && Objects.equals(this.phoneNumber, whatsAppIntegration.phoneNumber) && Objects.equals((Object)this.status, (Object)whatsAppIntegration.status) && Objects.equals(this.recipient, whatsAppIntegration.recipient) && Objects.equals(this.dateCreated, whatsAppIntegration.dateCreated) && Objects.equals(this.dateModified, whatsAppIntegration.dateModified) && Objects.equals(this.createdBy, whatsAppIntegration.createdBy) && Objects.equals(this.modifiedBy, whatsAppIntegration.modifiedBy) && Objects.equals(this.version, whatsAppIntegration.version) && Objects.equals((Object)this.activationStatusCode, (Object)whatsAppIntegration.activationStatusCode) && Objects.equals(this.activationErrorInfo, whatsAppIntegration.activationErrorInfo) && Objects.equals(this.selfUri, whatsAppIntegration.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.phoneNumber, this.status, this.recipient, this.dateCreated, this.dateModified, this.createdBy, this.modifiedBy, this.version, this.activationStatusCode, this.activationErrorInfo, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WhatsAppIntegration {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    phoneNumber: ").append(this.toIndentedString(this.phoneNumber)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    recipient: ").append(this.toIndentedString(this.recipient)).append("\n");
        sb.append("    dateCreated: ").append(this.toIndentedString(this.dateCreated)).append("\n");
        sb.append("    dateModified: ").append(this.toIndentedString(this.dateModified)).append("\n");
        sb.append("    createdBy: ").append(this.toIndentedString(this.createdBy)).append("\n");
        sb.append("    modifiedBy: ").append(this.toIndentedString(this.modifiedBy)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    activationStatusCode: ").append(this.toIndentedString((Object)this.activationStatusCode)).append("\n");
        sb.append("    activationErrorInfo: ").append(this.toIndentedString(this.activationErrorInfo)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ActivationStatusCodeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        CODESENT("CodeSent"),
        WAITREQUIRED("WaitRequired"),
        ACTIVATIONFAILED("ActivationFailed"),
        CODECONFIRMED("CodeConfirmed"),
        CONFIRMATIONFAILED("ConfirmationFailed"),
        RESENDCODE("ResendCode");

        private String value;

        private ActivationStatusCodeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ActivationStatusCodeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ActivationStatusCodeEnum value : ActivationStatusCodeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ActivationStatusCodeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum StatusEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ACTIVE("Active"),
        INACTIVE("Inactive"),
        ERROR("Error"),
        STARTING("Starting"),
        INCOMPLETE("Incomplete"),
        DELETING("Deleting"),
        DELETIONFAILED("DeletionFailed");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StatusEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StatusEnum value : StatusEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StatusEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

