/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="A complex type that defines service provider attributes, or sub-attributes and their qualities.")
public class ScimV2SchemaAttribute
implements Serializable {
    private String name = null;
    private TypeEnum type = null;
    private List<ScimV2SchemaAttribute> subAttributes = new ArrayList<ScimV2SchemaAttribute>();
    private Boolean multiValued = null;
    private String description = null;
    private Boolean required = null;
    private List<String> canonicalValues = new ArrayList<String>();
    private Boolean caseExact = null;
    private MutabilityEnum mutability = null;
    private ReturnedEnum returned = null;
    private UniquenessEnum uniqueness = null;
    private List<ReferenceTypesEnum> referenceTypes = new ArrayList<ReferenceTypesEnum>();

    @ApiModelProperty(example="null", value="The attribute's name")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @ApiModelProperty(example="null", value="The attribute's data type.  Valid values are \"string\", \"boolean\", \"decimal\", \"integer\", \"dateTime\", \"reference\", and \"complex\".")
    @JsonProperty(value="type")
    public TypeEnum getType() {
        return this.type;
    }

    public ScimV2SchemaAttribute subAttributes(List<ScimV2SchemaAttribute> subAttributes) {
        this.subAttributes = subAttributes;
        return this;
    }

    @ApiModelProperty(example="null", value="When an attribute is of type \"complex\", \"subAttributes\" defines a set of sub-attributes. \"subAttributes\" has the same schema sub-attributes as \"attributes\"")
    @JsonProperty(value="subAttributes")
    public List<ScimV2SchemaAttribute> getSubAttributes() {
        return this.subAttributes;
    }

    public void setSubAttributes(List<ScimV2SchemaAttribute> subAttributes) {
        this.subAttributes = subAttributes;
    }

    @ApiModelProperty(example="null", value="A Boolean value indicating the attribute's plurality.")
    @JsonProperty(value="multiValued")
    public Boolean getMultiValued() {
        return this.multiValued;
    }

    @ApiModelProperty(example="null", value="The attribute's human-readable description.")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @ApiModelProperty(example="null", value="A Boolean value that specifies whether or not the attribute is required.")
    @JsonProperty(value="required")
    public Boolean getRequired() {
        return this.required;
    }

    public ScimV2SchemaAttribute canonicalValues(List<String> canonicalValues) {
        this.canonicalValues = canonicalValues;
        return this;
    }

    @ApiModelProperty(example="null", value="A collection of suggested canonical values that MAY be used (e.g., \"work\" and \"home\").  In some cases, service providers MAY choose to ignore unsupported values.  OPTIONAL.")
    @JsonProperty(value="canonicalValues")
    public List<String> getCanonicalValues() {
        return this.canonicalValues;
    }

    public void setCanonicalValues(List<String> canonicalValues) {
        this.canonicalValues = canonicalValues;
    }

    @ApiModelProperty(example="null", value="A Boolean value that specifies whether or not a string attribute is case sensitive.  The server SHALL use case sensitivity when evaluating filters.  For attributes that are case exact, the server SHALL preserve case for any value submitted.  If the attribute is case insensitive, the server MAY alter case for a submitted value.  Case sensitivity also impacts how attribute values MAY be compared against filter values (see Section 3.4.2.2 of [RFC7644])")
    @JsonProperty(value="caseExact")
    public Boolean getCaseExact() {
        return this.caseExact;
    }

    @ApiModelProperty(example="null", value="A single keyword indicating the circumstances under which the value of the attribute can be (re)defined. Value are readOnly, readWrite, immutable, writeOnly")
    @JsonProperty(value="mutability")
    public MutabilityEnum getMutability() {
        return this.mutability;
    }

    @ApiModelProperty(example="null", value="A single keyword that indicates when an attribute and associated values are returned in response to a GET request, or in response to a PUT, POST, or PATCH request.  Valid keywords are as follows: always, never, default, request")
    @JsonProperty(value="returned")
    public ReturnedEnum getReturned() {
        return this.returned;
    }

    @ApiModelProperty(example="null", value="A single keyword value that specifies how the service provider enforces uniqueness of attribute values.  A server MAY reject an invalid value based on uniqueness by returning HTTP response code 400 (Bad Request).  A client MAY enforce uniqueness on the client side to a greater degree than the service provider enforces.  For example, a client could make a value unique while the server has uniqueness of \"none\".  Valid keywords are as follows: none, server, global")
    @JsonProperty(value="uniqueness")
    public UniquenessEnum getUniqueness() {
        return this.uniqueness;
    }

    public ScimV2SchemaAttribute referenceTypes(List<ReferenceTypesEnum> referenceTypes) {
        this.referenceTypes = referenceTypes;
        return this;
    }

    @ApiModelProperty(example="null", value="A multi-valued array of JSON strings that indicate the SCIM resource types that may be referenced. Values include User, Group, external and uri.")
    @JsonProperty(value="referenceTypes")
    public List<ReferenceTypesEnum> getReferenceTypes() {
        return this.referenceTypes;
    }

    public void setReferenceTypes(List<ReferenceTypesEnum> referenceTypes) {
        this.referenceTypes = referenceTypes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScimV2SchemaAttribute scimV2SchemaAttribute = (ScimV2SchemaAttribute)o;
        return Objects.equals(this.name, scimV2SchemaAttribute.name) && Objects.equals((Object)this.type, (Object)scimV2SchemaAttribute.type) && Objects.equals(this.subAttributes, scimV2SchemaAttribute.subAttributes) && Objects.equals(this.multiValued, scimV2SchemaAttribute.multiValued) && Objects.equals(this.description, scimV2SchemaAttribute.description) && Objects.equals(this.required, scimV2SchemaAttribute.required) && Objects.equals(this.canonicalValues, scimV2SchemaAttribute.canonicalValues) && Objects.equals(this.caseExact, scimV2SchemaAttribute.caseExact) && Objects.equals((Object)this.mutability, (Object)scimV2SchemaAttribute.mutability) && Objects.equals((Object)this.returned, (Object)scimV2SchemaAttribute.returned) && Objects.equals((Object)this.uniqueness, (Object)scimV2SchemaAttribute.uniqueness) && Objects.equals(this.referenceTypes, scimV2SchemaAttribute.referenceTypes);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.type, this.subAttributes, this.multiValued, this.description, this.required, this.canonicalValues, this.caseExact, this.mutability, this.returned, this.uniqueness, this.referenceTypes});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ScimV2SchemaAttribute {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    subAttributes: ").append(this.toIndentedString(this.subAttributes)).append("\n");
        sb.append("    multiValued: ").append(this.toIndentedString(this.multiValued)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    required: ").append(this.toIndentedString(this.required)).append("\n");
        sb.append("    canonicalValues: ").append(this.toIndentedString(this.canonicalValues)).append("\n");
        sb.append("    caseExact: ").append(this.toIndentedString(this.caseExact)).append("\n");
        sb.append("    mutability: ").append(this.toIndentedString((Object)this.mutability)).append("\n");
        sb.append("    returned: ").append(this.toIndentedString((Object)this.returned)).append("\n");
        sb.append("    uniqueness: ").append(this.toIndentedString((Object)this.uniqueness)).append("\n");
        sb.append("    referenceTypes: ").append(this.toIndentedString(this.referenceTypes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ReferenceTypesEnum {
        USER("USER"),
        GROUP("GROUP"),
        EXTERNAL("EXTERNAL"),
        URI("URI");

        private String value;

        private ReferenceTypesEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ReferenceTypesEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ReferenceTypesEnum value : ReferenceTypesEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ReferenceTypesEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum UniquenessEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        NONE("NONE"),
        SERVER("SERVER"),
        GLOBAL("GLOBAL");

        private String value;

        private UniquenessEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static UniquenessEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (UniquenessEnum value : UniquenessEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return UniquenessEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum ReturnedEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ALWAYS("ALWAYS"),
        NEVER("NEVER"),
        DEFAULT("DEFAULT"),
        REQUEST("REQUEST");

        private String value;

        private ReturnedEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ReturnedEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ReturnedEnum value : ReturnedEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ReturnedEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum MutabilityEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        READWRITE("readWrite"),
        READONLY("readOnly"),
        IMMUTABLE("immutable"),
        WRITEONLY("writeOnly");

        private String value;

        private MutabilityEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static MutabilityEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (MutabilityEnum value : MutabilityEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return MutabilityEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum TypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        STRING("STRING"),
        BOOLEAN("BOOLEAN"),
        DECIMAL("DECIMAL"),
        INTEGER("INTEGER"),
        DATE_TIME("DATE_TIME"),
        REFERENCE("REFERENCE"),
        COMPLEX("COMPLEX");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static TypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (TypeEnum value : TypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return TypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

