/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;

public class AnalyticsProperty
implements Serializable {
    private PropertyTypeEnum propertyType = null;
    private String property = null;
    private String value = null;

    public AnalyticsProperty propertyType(PropertyTypeEnum propertyType) {
        this.propertyType = propertyType;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Indicates what the data type is (e.g. integer vs string) and therefore how to evaluate what would constitute a match")
    @JsonProperty(value="propertyType")
    public PropertyTypeEnum getPropertyType() {
        return this.propertyType;
    }

    public void setPropertyType(PropertyTypeEnum propertyType) {
        this.propertyType = propertyType;
    }

    public AnalyticsProperty property(String property) {
        this.property = property;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="User-defined rather than intrinsic system-observed values. These are tagged onto segments by other components within PureCloud or by API users directly.  This is the name of the user-defined property.")
    @JsonProperty(value="property")
    public String getProperty() {
        return this.property;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public AnalyticsProperty value(String value) {
        this.value = value;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="What property value to match against")
    @JsonProperty(value="value")
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnalyticsProperty analyticsProperty = (AnalyticsProperty)o;
        return Objects.equals((Object)this.propertyType, (Object)analyticsProperty.propertyType) && Objects.equals(this.property, analyticsProperty.property) && Objects.equals(this.value, analyticsProperty.value);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.propertyType, this.property, this.value});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AnalyticsProperty {\n");
        sb.append("    propertyType: ").append(this.toIndentedString((Object)this.propertyType)).append("\n");
        sb.append("    property: ").append(this.toIndentedString(this.property)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum PropertyTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        BOOL("bool"),
        INTEGER("integer"),
        REAL("real"),
        DATE("date"),
        STRING("string"),
        UUID("uuid");

        private String value;

        private PropertyTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static PropertyTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (PropertyTypeEnum value : PropertyTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return PropertyTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

