/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

@ApiModel(description="POST request body for fetching the current user's schedule over a given range")
public class CurrentUserScheduleRequestBody
implements Serializable {
    private Date startDate = null;
    private Date endDate = null;
    private Boolean loadFullWeeks = null;

    public CurrentUserScheduleRequestBody startDate(Date startDate) {
        this.startDate = startDate;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Beginning of the range of schedules to fetch, in ISO-8601 format")
    @JsonProperty(value="startDate")
    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public CurrentUserScheduleRequestBody endDate(Date endDate) {
        this.endDate = endDate;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="End of the range of schedules to fetch, in ISO-8601 format")
    @JsonProperty(value="endDate")
    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public CurrentUserScheduleRequestBody loadFullWeeks(Boolean loadFullWeeks) {
        this.loadFullWeeks = loadFullWeeks;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether to load the full week's schedule (for the current user) of any week overlapping the start/end date query parameters, defaults to false")
    @JsonProperty(value="loadFullWeeks")
    public Boolean getLoadFullWeeks() {
        return this.loadFullWeeks;
    }

    public void setLoadFullWeeks(Boolean loadFullWeeks) {
        this.loadFullWeeks = loadFullWeeks;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CurrentUserScheduleRequestBody currentUserScheduleRequestBody = (CurrentUserScheduleRequestBody)o;
        return Objects.equals(this.startDate, currentUserScheduleRequestBody.startDate) && Objects.equals(this.endDate, currentUserScheduleRequestBody.endDate) && Objects.equals(this.loadFullWeeks, currentUserScheduleRequestBody.loadFullWeeks);
    }

    public int hashCode() {
        return Objects.hash(this.startDate, this.endDate, this.loadFullWeeks);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CurrentUserScheduleRequestBody {\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("    loadFullWeeks: ").append(this.toIndentedString(this.loadFullWeeks)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

