/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;

public class DomainCapabilities
implements Serializable {
    private Boolean enabled = null;
    private Boolean dhcp = null;
    private Integer metric = null;
    private Boolean autoMetric = null;
    private Boolean supportsMetric = null;
    private Boolean pingEnabled = null;

    public DomainCapabilities enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @ApiModelProperty(example="null", value="True if this address family on the interface is enabled.")
    @JsonProperty(value="enabled")
    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public DomainCapabilities dhcp(Boolean dhcp) {
        this.dhcp = dhcp;
        return this;
    }

    @ApiModelProperty(example="null", value="True if this address family on the interface is using DHCP.")
    @JsonProperty(value="dhcp")
    public Boolean getDhcp() {
        return this.dhcp;
    }

    public void setDhcp(Boolean dhcp) {
        this.dhcp = dhcp;
    }

    public DomainCapabilities metric(Integer metric) {
        this.metric = metric;
        return this;
    }

    @ApiModelProperty(example="null", value="The metric being used for the address family on this interface. Lower values will have a higher priority. If autoMetric is true, this value will be the automatically calculated metric. To set this value be sure autoMetric is false. If no value is returned, metric configuration is not supported on this Edge.")
    @JsonProperty(value="metric")
    public Integer getMetric() {
        return this.metric;
    }

    public void setMetric(Integer metric) {
        this.metric = metric;
    }

    public DomainCapabilities autoMetric(Boolean autoMetric) {
        this.autoMetric = autoMetric;
        return this;
    }

    @ApiModelProperty(example="null", value="True if the metric is being calculated automatically for the address family on this interface.")
    @JsonProperty(value="autoMetric")
    public Boolean getAutoMetric() {
        return this.autoMetric;
    }

    public void setAutoMetric(Boolean autoMetric) {
        this.autoMetric = autoMetric;
    }

    @ApiModelProperty(example="null", value="True if metric configuration is supported.")
    @JsonProperty(value="supportsMetric")
    public Boolean getSupportsMetric() {
        return this.supportsMetric;
    }

    public DomainCapabilities pingEnabled(Boolean pingEnabled) {
        this.pingEnabled = pingEnabled;
        return this;
    }

    @ApiModelProperty(example="null", value="Set to true to enable this address family on this interface to respond to ping requests.")
    @JsonProperty(value="pingEnabled")
    public Boolean getPingEnabled() {
        return this.pingEnabled;
    }

    public void setPingEnabled(Boolean pingEnabled) {
        this.pingEnabled = pingEnabled;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DomainCapabilities domainCapabilities = (DomainCapabilities)o;
        return Objects.equals(this.enabled, domainCapabilities.enabled) && Objects.equals(this.dhcp, domainCapabilities.dhcp) && Objects.equals(this.metric, domainCapabilities.metric) && Objects.equals(this.autoMetric, domainCapabilities.autoMetric) && Objects.equals(this.supportsMetric, domainCapabilities.supportsMetric) && Objects.equals(this.pingEnabled, domainCapabilities.pingEnabled);
    }

    public int hashCode() {
        return Objects.hash(this.enabled, this.dhcp, this.metric, this.autoMetric, this.supportsMetric, this.pingEnabled);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DomainCapabilities {\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    dhcp: ").append(this.toIndentedString(this.dhcp)).append("\n");
        sb.append("    metric: ").append(this.toIndentedString(this.metric)).append("\n");
        sb.append("    autoMetric: ").append(this.toIndentedString(this.autoMetric)).append("\n");
        sb.append("    supportsMetric: ").append(this.toIndentedString(this.supportsMetric)).append("\n");
        sb.append("    pingEnabled: ").append(this.toIndentedString(this.pingEnabled)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

