/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GetScimUserRequest {
    private String userId;
    private List<String> attributes;
    private List<String> excludedAttributes;
    private String ifNoneMatch;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public GetScimUserRequest withUserId(String userId) {
        this.setUserId(userId);
        return this;
    }

    public List<String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(List<String> attributes) {
        this.attributes = attributes;
    }

    public GetScimUserRequest withAttributes(List<String> attributes) {
        this.setAttributes(attributes);
        return this;
    }

    public List<String> getExcludedAttributes() {
        return this.excludedAttributes;
    }

    public void setExcludedAttributes(List<String> excludedAttributes) {
        this.excludedAttributes = excludedAttributes;
    }

    public GetScimUserRequest withExcludedAttributes(List<String> excludedAttributes) {
        this.setExcludedAttributes(excludedAttributes);
        return this;
    }

    public String getIfNoneMatch() {
        return this.ifNoneMatch;
    }

    public void setIfNoneMatch(String ifNoneMatch) {
        this.ifNoneMatch = ifNoneMatch;
    }

    public GetScimUserRequest withIfNoneMatch(String ifNoneMatch) {
        this.setIfNoneMatch(ifNoneMatch);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public GetScimUserRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        if (this.userId == null) {
            throw new IllegalStateException("Missing the required parameter 'userId' when building request for GetScimUserRequest.");
        }
        return ApiRequestBuilder.create("GET", "/api/v2/scim/users/{userId}").withPathParameter("userId", this.userId).withQueryParameters("attributes", "multi", this.attributes).withQueryParameters("excludedAttributes", "multi", this.excludedAttributes).withHeaderParameter("If-None-Match", this.ifNoneMatch).withCustomHeaders(this.customHeaders).withContentTypes("application/json", "application/scim+json").withAccepts("application/json", "application/scim+json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String userId) {
        return new Builder().withRequiredParams(userId);
    }

    public static class Builder {
        private final GetScimUserRequest request = new GetScimUserRequest();

        private Builder() {
        }

        public Builder withUserId(String userId) {
            this.request.setUserId(userId);
            return this;
        }

        public Builder withAttributes(List<String> attributes) {
            this.request.setAttributes(attributes);
            return this;
        }

        public Builder withAttributesEnumValues(List<attributesValues> attributes) {
            ArrayList<String> stringList = new ArrayList<String>();
            for (attributesValues e : attributes) {
                stringList.add(e.toString());
            }
            this.request.setAttributes(stringList);
            return this;
        }

        public Builder withExcludedAttributes(List<String> excludedAttributes) {
            this.request.setExcludedAttributes(excludedAttributes);
            return this;
        }

        public Builder withExcludedAttributesEnumValues(List<excludedAttributesValues> excludedAttributes) {
            ArrayList<String> stringList = new ArrayList<String>();
            for (excludedAttributesValues e : excludedAttributes) {
                stringList.add(e.toString());
            }
            this.request.setExcludedAttributes(stringList);
            return this;
        }

        public Builder withIfNoneMatch(String ifNoneMatch) {
            this.request.setIfNoneMatch(ifNoneMatch);
            return this;
        }

        public Builder withRequiredParams(String userId) {
            this.request.setUserId(userId);
            return this;
        }

        public GetScimUserRequest build() {
            if (this.request.userId == null) {
                throw new IllegalStateException("Missing the required parameter 'userId' when building request for GetScimUserRequest.");
            }
            return this.request;
        }
    }

    public static enum excludedAttributesValues {
        ID("id"),
        USERNAME("userName"),
        DISPLAYNAME("displayName"),
        TITLE("title"),
        ACTIVE("active"),
        EXTERNALID("externalId"),
        PHONENUMBERS("phoneNumbers"),
        EMAILS("emails"),
        GROUPS("groups"),
        ROLES("roles"),
        URN_IETF_PARAMS_SCIM_SCHEMAS_CORE_2_0_USER_ID("urn:ietf:params:scim:schemas:core:2.0:User:id"),
        URN_IETF_PARAMS_SCIM_SCHEMAS_CORE_2_0_USER_USERNAME("urn:ietf:params:scim:schemas:core:2.0:User:userName"),
        URN_IETF_PARAMS_SCIM_SCHEMAS_CORE_2_0_USER_DISPLAYNAME("urn:ietf:params:scim:schemas:core:2.0:User:displayName"),
        URN_IETF_PARAMS_SCIM_SCHEMAS_CORE_2_0_USER_TITLE("urn:ietf:params:scim:schemas:core:2.0:User:title"),
        URN_IETF_PARAMS_SCIM_SCHEMAS_CORE_2_0_USER_ACTIVE("urn:ietf:params:scim:schemas:core:2.0:User:active"),
        URN_IETF_PARAMS_SCIM_SCHEMAS_CORE_2_0_USER_EXTERNALID("urn:ietf:params:scim:schemas:core:2.0:User:externalId"),
        URN_IETF_PARAMS_SCIM_SCHEMAS_CORE_2_0_USER_PHONENUMBERS("urn:ietf:params:scim:schemas:core:2.0:User:phoneNumbers"),
        URN_IETF_PARAMS_SCIM_SCHEMAS_CORE_2_0_USER_EMAILS("urn:ietf:params:scim:schemas:core:2.0:User:emails"),
        URN_IETF_PARAMS_SCIM_SCHEMAS_CORE_2_0_USER_GROUPS("urn:ietf:params:scim:schemas:core:2.0:User:groups"),
        URN_IETF_PARAMS_SCIM_SCHEMAS_CORE_2_0_USER_ROLES("urn:ietf:params:scim:schemas:core:2.0:User:roles"),
        URN_IETF_PARAMS_SCIM_SCHEMAS_EXTENSION_ENTERPRISE_2_0_USER("urn:ietf:params:scim:schemas:extension:enterprise:2.0:User"),
        URN_IETF_PARAMS_SCIM_SCHEMAS_EXTENSION_ENTERPRISE_2_0_USER_DIVISION("urn:ietf:params:scim:schemas:extension:enterprise:2.0:User:division"),
        URN_IETF_PARAMS_SCIM_SCHEMAS_EXTENSION_ENTERPRISE_2_0_USER_DEPARTMENT("urn:ietf:params:scim:schemas:extension:enterprise:2.0:User:department"),
        URN_IETF_PARAMS_SCIM_SCHEMAS_EXTENSION_ENTERPRISE_2_0_USER_MANAGER("urn:ietf:params:scim:schemas:extension:enterprise:2.0:User:manager"),
        URN_IETF_PARAMS_SCIM_SCHEMAS_EXTENSION_ENTERPRISE_2_0_USER_MANAGER_VALUE("urn:ietf:params:scim:schemas:extension:enterprise:2.0:User:manager.value"),
        URN_IETF_PARAMS_SCIM_SCHEMAS_EXTENSION_ENTERPRISE_2_0_USER_EMPLOYEENUMBER("urn:ietf:params:scim:schemas:extension:enterprise:2.0:User:employeeNumber"),
        URN_IETF_PARAMS_SCIM_SCHEMAS_EXTENSION_GENESYS_PURECLOUD_2_0_USER("urn:ietf:params:scim:schemas:extension:genesys:purecloud:2.0:User"),
        URN_IETF_PARAMS_SCIM_SCHEMAS_EXTENSION_GENESYS_PURECLOUD_2_0_USER_ROUTINGSKILLS("urn:ietf:params:scim:schemas:extension:genesys:purecloud:2.0:User:routingSkills"),
        URN_IETF_PARAMS_SCIM_SCHEMAS_EXTENSION_GENESYS_PURECLOUD_2_0_USER_ROUTINGLANGUAGES("urn:ietf:params:scim:schemas:extension:genesys:purecloud:2.0:User:routingLanguages");

        private String value;

        private excludedAttributesValues(String value) {
            this.value = value;
        }

        @JsonCreator
        public static excludedAttributesValues fromString(String key) {
            if (key == null) {
                return null;
            }
            for (excludedAttributesValues value : excludedAttributesValues.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return excludedAttributesValues.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum attributesValues {
        ID("id"),
        USERNAME("userName"),
        DISPLAYNAME("displayName"),
        TITLE("title"),
        ACTIVE("active"),
        EXTERNALID("externalId"),
        PHONENUMBERS("phoneNumbers"),
        EMAILS("emails"),
        GROUPS("groups"),
        ROLES("roles"),
        URN_IETF_PARAMS_SCIM_SCHEMAS_CORE_2_0_USER_ID("urn:ietf:params:scim:schemas:core:2.0:User:id"),
        URN_IETF_PARAMS_SCIM_SCHEMAS_CORE_2_0_USER_USERNAME("urn:ietf:params:scim:schemas:core:2.0:User:userName"),
        URN_IETF_PARAMS_SCIM_SCHEMAS_CORE_2_0_USER_DISPLAYNAME("urn:ietf:params:scim:schemas:core:2.0:User:displayName"),
        URN_IETF_PARAMS_SCIM_SCHEMAS_CORE_2_0_USER_TITLE("urn:ietf:params:scim:schemas:core:2.0:User:title"),
        URN_IETF_PARAMS_SCIM_SCHEMAS_CORE_2_0_USER_ACTIVE("urn:ietf:params:scim:schemas:core:2.0:User:active"),
        URN_IETF_PARAMS_SCIM_SCHEMAS_CORE_2_0_USER_EXTERNALID("urn:ietf:params:scim:schemas:core:2.0:User:externalId"),
        URN_IETF_PARAMS_SCIM_SCHEMAS_CORE_2_0_USER_PHONENUMBERS("urn:ietf:params:scim:schemas:core:2.0:User:phoneNumbers"),
        URN_IETF_PARAMS_SCIM_SCHEMAS_CORE_2_0_USER_EMAILS("urn:ietf:params:scim:schemas:core:2.0:User:emails"),
        URN_IETF_PARAMS_SCIM_SCHEMAS_CORE_2_0_USER_GROUPS("urn:ietf:params:scim:schemas:core:2.0:User:groups"),
        URN_IETF_PARAMS_SCIM_SCHEMAS_CORE_2_0_USER_ROLES("urn:ietf:params:scim:schemas:core:2.0:User:roles"),
        URN_IETF_PARAMS_SCIM_SCHEMAS_EXTENSION_ENTERPRISE_2_0_USER("urn:ietf:params:scim:schemas:extension:enterprise:2.0:User"),
        URN_IETF_PARAMS_SCIM_SCHEMAS_EXTENSION_ENTERPRISE_2_0_USER_DIVISION("urn:ietf:params:scim:schemas:extension:enterprise:2.0:User:division"),
        URN_IETF_PARAMS_SCIM_SCHEMAS_EXTENSION_ENTERPRISE_2_0_USER_DEPARTMENT("urn:ietf:params:scim:schemas:extension:enterprise:2.0:User:department"),
        URN_IETF_PARAMS_SCIM_SCHEMAS_EXTENSION_ENTERPRISE_2_0_USER_MANAGER("urn:ietf:params:scim:schemas:extension:enterprise:2.0:User:manager"),
        URN_IETF_PARAMS_SCIM_SCHEMAS_EXTENSION_ENTERPRISE_2_0_USER_MANAGER_VALUE("urn:ietf:params:scim:schemas:extension:enterprise:2.0:User:manager.value"),
        URN_IETF_PARAMS_SCIM_SCHEMAS_EXTENSION_ENTERPRISE_2_0_USER_EMPLOYEENUMBER("urn:ietf:params:scim:schemas:extension:enterprise:2.0:User:employeeNumber"),
        URN_IETF_PARAMS_SCIM_SCHEMAS_EXTENSION_GENESYS_PURECLOUD_2_0_USER("urn:ietf:params:scim:schemas:extension:genesys:purecloud:2.0:User"),
        URN_IETF_PARAMS_SCIM_SCHEMAS_EXTENSION_GENESYS_PURECLOUD_2_0_USER_ROUTINGSKILLS("urn:ietf:params:scim:schemas:extension:genesys:purecloud:2.0:User:routingSkills"),
        URN_IETF_PARAMS_SCIM_SCHEMAS_EXTENSION_GENESYS_PURECLOUD_2_0_USER_ROUTINGLANGUAGES("urn:ietf:params:scim:schemas:extension:genesys:purecloud:2.0:User:routingLanguages");

        private String value;

        private attributesValues(String value) {
            this.value = value;
        }

        @JsonCreator
        public static attributesValues fromString(String key) {
            if (key == null) {
                return null;
            }
            for (attributesValues value : attributesValues.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return attributesValues.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

