/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GetScimGroupRequest {
    private String groupId;
    private List<String> attributes;
    private List<String> excludedAttributes;
    private String ifNoneMatch;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public GetScimGroupRequest withGroupId(String groupId) {
        this.setGroupId(groupId);
        return this;
    }

    public List<String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(List<String> attributes) {
        this.attributes = attributes;
    }

    public GetScimGroupRequest withAttributes(List<String> attributes) {
        this.setAttributes(attributes);
        return this;
    }

    public List<String> getExcludedAttributes() {
        return this.excludedAttributes;
    }

    public void setExcludedAttributes(List<String> excludedAttributes) {
        this.excludedAttributes = excludedAttributes;
    }

    public GetScimGroupRequest withExcludedAttributes(List<String> excludedAttributes) {
        this.setExcludedAttributes(excludedAttributes);
        return this;
    }

    public String getIfNoneMatch() {
        return this.ifNoneMatch;
    }

    public void setIfNoneMatch(String ifNoneMatch) {
        this.ifNoneMatch = ifNoneMatch;
    }

    public GetScimGroupRequest withIfNoneMatch(String ifNoneMatch) {
        this.setIfNoneMatch(ifNoneMatch);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public GetScimGroupRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        if (this.groupId == null) {
            throw new IllegalStateException("Missing the required parameter 'groupId' when building request for GetScimGroupRequest.");
        }
        return ApiRequestBuilder.create("GET", "/api/v2/scim/groups/{groupId}").withPathParameter("groupId", this.groupId).withQueryParameters("attributes", "multi", this.attributes).withQueryParameters("excludedAttributes", "multi", this.excludedAttributes).withHeaderParameter("If-None-Match", this.ifNoneMatch).withCustomHeaders(this.customHeaders).withContentTypes("application/json", "application/scim+json").withAccepts("application/json", "application/scim+json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String groupId) {
        return new Builder().withRequiredParams(groupId);
    }

    public static class Builder {
        private final GetScimGroupRequest request = new GetScimGroupRequest();

        private Builder() {
        }

        public Builder withGroupId(String groupId) {
            this.request.setGroupId(groupId);
            return this;
        }

        public Builder withAttributes(List<String> attributes) {
            this.request.setAttributes(attributes);
            return this;
        }

        public Builder withAttributesEnumValues(List<attributesValues> attributes) {
            ArrayList<String> stringList = new ArrayList<String>();
            for (attributesValues e : attributes) {
                stringList.add(e.toString());
            }
            this.request.setAttributes(stringList);
            return this;
        }

        public Builder withExcludedAttributes(List<String> excludedAttributes) {
            this.request.setExcludedAttributes(excludedAttributes);
            return this;
        }

        public Builder withExcludedAttributesEnumValues(List<excludedAttributesValues> excludedAttributes) {
            ArrayList<String> stringList = new ArrayList<String>();
            for (excludedAttributesValues e : excludedAttributes) {
                stringList.add(e.toString());
            }
            this.request.setExcludedAttributes(stringList);
            return this;
        }

        public Builder withIfNoneMatch(String ifNoneMatch) {
            this.request.setIfNoneMatch(ifNoneMatch);
            return this;
        }

        public Builder withRequiredParams(String groupId) {
            this.request.setGroupId(groupId);
            return this;
        }

        public GetScimGroupRequest build() {
            if (this.request.groupId == null) {
                throw new IllegalStateException("Missing the required parameter 'groupId' when building request for GetScimGroupRequest.");
            }
            return this.request;
        }
    }

    public static enum excludedAttributesValues {
        ID("id"),
        DISPLAYNAME("displayName"),
        MEMBERS("members"),
        EXTERNALID("externalId"),
        URN_IETF_PARAMS_SCIM_SCHEMAS_CORE_2_0_GROUP_ID("urn:ietf:params:scim:schemas:core:2.0:Group:id"),
        URN_IETF_PARAMS_SCIM_SCHEMAS_CORE_2_0_GROUP_DISPLAYNAME("urn:ietf:params:scim:schemas:core:2.0:Group:displayName"),
        URN_IETF_PARAMS_SCIM_SCHEMAS_CORE_2_0_GROUP_MEMBERS("urn:ietf:params:scim:schemas:core:2.0:Group:members"),
        URN_IETF_PARAMS_SCIM_SCHEMAS_CORE_2_0_GROUP_EXTERNALID("urn:ietf:params:scim:schemas:core:2.0:Group:externalId");

        private String value;

        private excludedAttributesValues(String value) {
            this.value = value;
        }

        @JsonCreator
        public static excludedAttributesValues fromString(String key) {
            if (key == null) {
                return null;
            }
            for (excludedAttributesValues value : excludedAttributesValues.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return excludedAttributesValues.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum attributesValues {
        ID("id"),
        DISPLAYNAME("displayName"),
        MEMBERS("members"),
        EXTERNALID("externalId"),
        URN_IETF_PARAMS_SCIM_SCHEMAS_CORE_2_0_GROUP_ID("urn:ietf:params:scim:schemas:core:2.0:Group:id"),
        URN_IETF_PARAMS_SCIM_SCHEMAS_CORE_2_0_GROUP_DISPLAYNAME("urn:ietf:params:scim:schemas:core:2.0:Group:displayName"),
        URN_IETF_PARAMS_SCIM_SCHEMAS_CORE_2_0_GROUP_MEMBERS("urn:ietf:params:scim:schemas:core:2.0:Group:members"),
        URN_IETF_PARAMS_SCIM_SCHEMAS_CORE_2_0_GROUP_EXTERNALID("urn:ietf:params:scim:schemas:core:2.0:Group:externalId");

        private String value;

        private attributesValues(String value) {
            this.value = value;
        }

        @JsonCreator
        public static attributesValues fromString(String key) {
            if (key == null) {
                return null;
            }
            for (attributesValues value : attributesValues.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return attributesValues.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

