/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2;

import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;

public class ApiDateFormat
extends DateFormat {
    List<String> formatStrings = new ArrayList<String>(Arrays.asList("yyyy-MM-dd'T'HH:mm:ss.SSSXXX", "yyyy-MM-dd'T'HH:mm:ssXXX", "yyyy-MM-dd'T'HH:mm:ss.SSS"));
    List<SimpleDateFormat> formats = new ArrayList<SimpleDateFormat>();

    public ApiDateFormat() {
        this.setCalendar(Calendar.getInstance(TimeZone.getTimeZone("UTC")));
        this.setNumberFormat(NumberFormat.getInstance());
        for (String formatString : this.formatStrings) {
            SimpleDateFormat format = new SimpleDateFormat(formatString);
            format.setTimeZone(TimeZone.getTimeZone("UTC"));
            this.formats.add(format);
        }
    }

    @Override
    public StringBuffer format(Date date, StringBuffer toAppendTo, FieldPosition fieldPosition) {
        return this.formats.get(0).format(date, toAppendTo, fieldPosition);
    }

    @Override
    public Date parse(String source, ParsePosition pos) {
        for (SimpleDateFormat format : this.formats) {
            try {
                Date d = format.parse(source, pos);
                if (d == null) continue;
                return d;
            }
            catch (NullPointerException e) {
            }
        }
        return null;
    }

    @Override
    public Object clone() {
        return new ApiDateFormat();
    }

    @Override
    public void setTimeZone(TimeZone zone) {
        this.calendar.setTimeZone(zone);
        for (SimpleDateFormat format : this.formats) {
            format.setTimeZone(zone);
        }
    }
}

