/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class Condition
implements Serializable {
    private TypeEnum type = null;
    private Boolean inverted = null;
    private String attributeName = null;
    private String value = null;
    private ValueTypeEnum valueType = null;
    private OperatorEnum operator = null;
    private List<String> codes = new ArrayList<String>();

    public Condition type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(example="null", value="The type of the condition")
    @JsonProperty(value="type")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public Condition inverted(Boolean inverted) {
        this.inverted = inverted;
        return this;
    }

    @ApiModelProperty(example="null", value="Indicates whether to evaluate for the opposite of the stated condition; default is false")
    @JsonProperty(value="inverted")
    public Boolean getInverted() {
        return this.inverted;
    }

    public void setInverted(Boolean inverted) {
        this.inverted = inverted;
    }

    public Condition attributeName(String attributeName) {
        this.attributeName = attributeName;
        return this;
    }

    @ApiModelProperty(example="null", value="An attribute name associated with the condition (applies only to certain rule conditions)")
    @JsonProperty(value="attributeName")
    public String getAttributeName() {
        return this.attributeName;
    }

    public void setAttributeName(String attributeName) {
        this.attributeName = attributeName;
    }

    public Condition value(String value) {
        this.value = value;
        return this;
    }

    @ApiModelProperty(example="null", value="A value associated with the condition. This could be text, a number, or a relative time. A value for relative time should follow the format PxxDTyyHzzM, where xx, yy, and zz specify the days, hours and minutes. For example, a value of P01DT08H30M corresponds to 1 day, 8 hours, and 30 minutes from now. To specify a time in the past, include a negative sign before each numeric value. For example, a value of P-01DT-08H-30M corresponds to 1 day, 8 hours, and 30 minutes in the past. You can also do things like P01DT00H-30M, which would correspond to 23 hours and 30 minutes from now (1 day - 30 minutes).")
    @JsonProperty(value="value")
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public Condition valueType(ValueTypeEnum valueType) {
        this.valueType = valueType;
        return this;
    }

    @ApiModelProperty(example="null", value="Determines the type of the value associated with the condition")
    @JsonProperty(value="valueType")
    public ValueTypeEnum getValueType() {
        return this.valueType;
    }

    public void setValueType(ValueTypeEnum valueType) {
        this.valueType = valueType;
    }

    public Condition operator(OperatorEnum operator) {
        this.operator = operator;
        return this;
    }

    @ApiModelProperty(example="null", value="An operation type for condition evaluation")
    @JsonProperty(value="operator")
    public OperatorEnum getOperator() {
        return this.operator;
    }

    public void setOperator(OperatorEnum operator) {
        this.operator = operator;
    }

    public Condition codes(List<String> codes) {
        this.codes = codes;
        return this;
    }

    @ApiModelProperty(example="null", value="List of wrap-up code identifiers (used only in conditions of type 'wrapupCondition')")
    @JsonProperty(value="codes")
    public List<String> getCodes() {
        return this.codes;
    }

    public void setCodes(List<String> codes) {
        this.codes = codes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Condition condition = (Condition)o;
        return Objects.equals((Object)this.type, (Object)condition.type) && Objects.equals(this.inverted, condition.inverted) && Objects.equals(this.attributeName, condition.attributeName) && Objects.equals(this.value, condition.value) && Objects.equals((Object)this.valueType, (Object)condition.valueType) && Objects.equals((Object)this.operator, (Object)condition.operator) && Objects.equals(this.codes, condition.codes);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.inverted, this.attributeName, this.value, this.valueType, this.operator, this.codes});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Condition {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    inverted: ").append(this.toIndentedString(this.inverted)).append("\n");
        sb.append("    attributeName: ").append(this.toIndentedString(this.attributeName)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    valueType: ").append(this.toIndentedString((Object)this.valueType)).append("\n");
        sb.append("    operator: ").append(this.toIndentedString((Object)this.operator)).append("\n");
        sb.append("    codes: ").append(this.toIndentedString(this.codes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum OperatorEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        EQUALS("EQUALS"),
        LESS_THAN("LESS_THAN"),
        LESS_THAN_EQUALS("LESS_THAN_EQUALS"),
        GREATER_THAN("GREATER_THAN"),
        GREATER_THAN_EQUALS("GREATER_THAN_EQUALS"),
        CONTAINS("CONTAINS"),
        BEGINS_WITH("BEGINS_WITH"),
        ENDS_WITH("ENDS_WITH"),
        BEFORE("BEFORE"),
        AFTER("AFTER");

        private String value;

        private OperatorEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static OperatorEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (OperatorEnum value : OperatorEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return OperatorEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum ValueTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        STRING("STRING"),
        NUMERIC("NUMERIC"),
        DATETIME("DATETIME"),
        PERIOD("PERIOD");

        private String value;

        private ValueTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ValueTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ValueTypeEnum value : ValueTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ValueTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum TypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        WRAPUPCONDITION("wrapupCondition"),
        CONTACTATTRIBUTECONDITION("contactAttributeCondition"),
        PHONENUMBERCONDITION("phoneNumberCondition"),
        PHONENUMBERTYPECONDITION("phoneNumberTypeCondition"),
        CALLANALYSISCONDITION("callAnalysisCondition"),
        CONTACTPROPERTYCONDITION("contactPropertyCondition");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static TypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (TypeEnum value : TypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return TypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

