/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.FeatureState;
import java.util.HashMap;
import java.util.Map;

public class PatchOrganizationsFeatureRequest {
    private String featureName;
    private FeatureState enabled;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getFeatureName() {
        return this.featureName;
    }

    public void setFeatureName(String featureName) {
        this.featureName = featureName;
    }

    public PatchOrganizationsFeatureRequest withFeatureName(String featureName) {
        this.setFeatureName(featureName);
        return this;
    }

    public FeatureState getEnabled() {
        return this.enabled;
    }

    public void setEnabled(FeatureState enabled) {
        this.enabled = enabled;
    }

    public PatchOrganizationsFeatureRequest withEnabled(FeatureState enabled) {
        this.setEnabled(enabled);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PatchOrganizationsFeatureRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<FeatureState> withHttpInfo() {
        if (this.featureName == null) {
            throw new IllegalStateException("Missing the required parameter 'featureName' when building request for PatchOrganizationsFeatureRequest.");
        }
        if (this.enabled == null) {
            throw new IllegalStateException("Missing the required parameter 'enabled' when building request for PatchOrganizationsFeatureRequest.");
        }
        return ApiRequestBuilder.create("PATCH", "/api/v2/organizations/features/{featureName}").withPathParameter("featureName", this.featureName).withBody(this.enabled).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud Auth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String featureName, FeatureState enabled) {
        return new Builder().withRequiredParams(featureName, enabled);
    }

    public static class Builder {
        private final PatchOrganizationsFeatureRequest request = new PatchOrganizationsFeatureRequest();

        private Builder() {
        }

        public Builder withFeatureName(String featureName) {
            this.request.setFeatureName(featureName);
            return this;
        }

        public Builder withEnabled(FeatureState enabled) {
            this.request.setEnabled(enabled);
            return this;
        }

        public Builder withRequiredParams(String featureName, FeatureState enabled) {
            this.request.setFeatureName(featureName);
            this.request.setEnabled(enabled);
            return this;
        }

        public PatchOrganizationsFeatureRequest build() {
            if (this.request.featureName == null) {
                throw new IllegalStateException("Missing the required parameter 'featureName' when building request for PatchOrganizationsFeatureRequest.");
            }
            if (this.request.enabled == null) {
                throw new IllegalStateException("Missing the required parameter 'enabled' when building request for PatchOrganizationsFeatureRequest.");
            }
            return this.request;
        }
    }
}

