/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2;

import com.google.common.collect.Lists;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.joda.time.DateTime;
import org.joda.time.LocalDateTime;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;
import org.joda.time.format.DateTimePrinter;
import org.joda.time.format.ISODateTimeFormat;

public class JodaApiDateFormat
extends DateFormat {
    private final List<DateTimeFormatter> formats;
    private final DateTimePrinter printer = new DateTimeFormatterBuilder().append(ISODateTimeFormat.dateTime()).toPrinter();

    public JodaApiDateFormat() {
        this.setCalendar(Calendar.getInstance(TimeZone.getTimeZone("UTC")));
        this.setNumberFormat(NumberFormat.getInstance());
        this.formats = Lists.newArrayList((Object[])new DateTimeFormatter[]{ISODateTimeFormat.dateTime(), DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ssZ"), DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss.SSS")});
    }

    @Override
    public StringBuffer format(Date date, StringBuffer toAppendTo, FieldPosition fieldPosition) {
        if (toAppendTo == null) {
            toAppendTo = new StringBuffer(this.printer.estimatePrintedLength());
        }
        this.printer.printTo(toAppendTo, (ReadablePartial)new LocalDateTime((Object)date), Locale.US);
        return toAppendTo;
    }

    @Override
    public Date parse(String source, ParsePosition pos) {
        for (DateTimeFormatter format : this.formats) {
            try {
                DateTime date = format.parseDateTime(source);
                if (date == null) continue;
                pos.setIndex(source.length() - 1);
                return date.toDate();
            }
            catch (Exception exception) {
            }
        }
        return null;
    }
}

