/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.model.RouteGroupList;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Request body for importing a short term forecast")
public class ImportShortTermForecastRequest
implements Serializable {
    private String fileName = null;
    private String description = null;
    private RouteGroupList routeGroupList = null;
    private List<String> partialUploadIds = new ArrayList<String>();

    public ImportShortTermForecastRequest fileName(String fileName) {
        this.fileName = fileName;
        return this;
    }

    @ApiModelProperty(example="null", value="The file name, if applicable, this data was extracted from (display purposes only)")
    @JsonProperty(value="fileName")
    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public ImportShortTermForecastRequest description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Description for the imported forecast.  Pass an empty string for no description")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ImportShortTermForecastRequest routeGroupList(RouteGroupList routeGroupList) {
        this.routeGroupList = routeGroupList;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The raw data to import")
    @JsonProperty(value="routeGroupList")
    public RouteGroupList getRouteGroupList() {
        return this.routeGroupList;
    }

    public void setRouteGroupList(RouteGroupList routeGroupList) {
        this.routeGroupList = routeGroupList;
    }

    public ImportShortTermForecastRequest partialUploadIds(List<String> partialUploadIds) {
        this.partialUploadIds = partialUploadIds;
        return this;
    }

    @ApiModelProperty(example="null", value="IDs of partial uploads to include in this imported forecast.  Only relevant for large forecasts")
    @JsonProperty(value="partialUploadIds")
    public List<String> getPartialUploadIds() {
        return this.partialUploadIds;
    }

    public void setPartialUploadIds(List<String> partialUploadIds) {
        this.partialUploadIds = partialUploadIds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImportShortTermForecastRequest importShortTermForecastRequest = (ImportShortTermForecastRequest)o;
        return Objects.equals(this.fileName, importShortTermForecastRequest.fileName) && Objects.equals(this.description, importShortTermForecastRequest.description) && Objects.equals(this.routeGroupList, importShortTermForecastRequest.routeGroupList) && Objects.equals(this.partialUploadIds, importShortTermForecastRequest.partialUploadIds);
    }

    public int hashCode() {
        return Objects.hash(this.fileName, this.description, this.routeGroupList, this.partialUploadIds);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ImportShortTermForecastRequest {\n");
        sb.append("    fileName: ").append(this.toIndentedString(this.fileName)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    routeGroupList: ").append(this.toIndentedString(this.routeGroupList)).append("\n");
        sb.append("    partialUploadIds: ").append(this.toIndentedString(this.partialUploadIds)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

