/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.model.RouteGroupAttributes;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Route group for calculated forecasts")
public class RouteGroup
implements Serializable {
    private RouteGroupAttributes attributes = null;
    private List<Double> offeredPerInterval = new ArrayList<Double>();
    private List<Double> averageTalkTimeSecondsPerInterval = new ArrayList<Double>();
    private List<Double> averageAfterCallWorkSecondsPerInterval = new ArrayList<Double>();
    private List<Double> completedPerInterval = new ArrayList<Double>();
    private List<Double> abandonedPerInterval = new ArrayList<Double>();

    public RouteGroup attributes(RouteGroupAttributes attributes) {
        this.attributes = attributes;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The attributes that describe this route group")
    @JsonProperty(value="attributes")
    public RouteGroupAttributes getAttributes() {
        return this.attributes;
    }

    public void setAttributes(RouteGroupAttributes attributes) {
        this.attributes = attributes;
    }

    public RouteGroup offeredPerInterval(List<Double> offeredPerInterval) {
        this.offeredPerInterval = offeredPerInterval;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Interactions offered per 15 minute interval")
    @JsonProperty(value="offeredPerInterval")
    public List<Double> getOfferedPerInterval() {
        return this.offeredPerInterval;
    }

    public void setOfferedPerInterval(List<Double> offeredPerInterval) {
        this.offeredPerInterval = offeredPerInterval;
    }

    public RouteGroup averageTalkTimeSecondsPerInterval(List<Double> averageTalkTimeSecondsPerInterval) {
        this.averageTalkTimeSecondsPerInterval = averageTalkTimeSecondsPerInterval;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Average talk time in seconds per 15 minute interval")
    @JsonProperty(value="averageTalkTimeSecondsPerInterval")
    public List<Double> getAverageTalkTimeSecondsPerInterval() {
        return this.averageTalkTimeSecondsPerInterval;
    }

    public void setAverageTalkTimeSecondsPerInterval(List<Double> averageTalkTimeSecondsPerInterval) {
        this.averageTalkTimeSecondsPerInterval = averageTalkTimeSecondsPerInterval;
    }

    public RouteGroup averageAfterCallWorkSecondsPerInterval(List<Double> averageAfterCallWorkSecondsPerInterval) {
        this.averageAfterCallWorkSecondsPerInterval = averageAfterCallWorkSecondsPerInterval;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Average after call work in seconds per 15 minute interval")
    @JsonProperty(value="averageAfterCallWorkSecondsPerInterval")
    public List<Double> getAverageAfterCallWorkSecondsPerInterval() {
        return this.averageAfterCallWorkSecondsPerInterval;
    }

    public void setAverageAfterCallWorkSecondsPerInterval(List<Double> averageAfterCallWorkSecondsPerInterval) {
        this.averageAfterCallWorkSecondsPerInterval = averageAfterCallWorkSecondsPerInterval;
    }

    public RouteGroup completedPerInterval(List<Double> completedPerInterval) {
        this.completedPerInterval = completedPerInterval;
        return this;
    }

    @ApiModelProperty(example="null", value="Interactions completed per 15 minute interval")
    @JsonProperty(value="completedPerInterval")
    public List<Double> getCompletedPerInterval() {
        return this.completedPerInterval;
    }

    public void setCompletedPerInterval(List<Double> completedPerInterval) {
        this.completedPerInterval = completedPerInterval;
    }

    public RouteGroup abandonedPerInterval(List<Double> abandonedPerInterval) {
        this.abandonedPerInterval = abandonedPerInterval;
        return this;
    }

    @ApiModelProperty(example="null", value="Interactions abandoned per 15 minute interval")
    @JsonProperty(value="abandonedPerInterval")
    public List<Double> getAbandonedPerInterval() {
        return this.abandonedPerInterval;
    }

    public void setAbandonedPerInterval(List<Double> abandonedPerInterval) {
        this.abandonedPerInterval = abandonedPerInterval;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RouteGroup routeGroup = (RouteGroup)o;
        return Objects.equals(this.attributes, routeGroup.attributes) && Objects.equals(this.offeredPerInterval, routeGroup.offeredPerInterval) && Objects.equals(this.averageTalkTimeSecondsPerInterval, routeGroup.averageTalkTimeSecondsPerInterval) && Objects.equals(this.averageAfterCallWorkSecondsPerInterval, routeGroup.averageAfterCallWorkSecondsPerInterval) && Objects.equals(this.completedPerInterval, routeGroup.completedPerInterval) && Objects.equals(this.abandonedPerInterval, routeGroup.abandonedPerInterval);
    }

    public int hashCode() {
        return Objects.hash(this.attributes, this.offeredPerInterval, this.averageTalkTimeSecondsPerInterval, this.averageAfterCallWorkSecondsPerInterval, this.completedPerInterval, this.abandonedPerInterval);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RouteGroup {\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    offeredPerInterval: ").append(this.toIndentedString(this.offeredPerInterval)).append("\n");
        sb.append("    averageTalkTimeSecondsPerInterval: ").append(this.toIndentedString(this.averageTalkTimeSecondsPerInterval)).append("\n");
        sb.append("    averageAfterCallWorkSecondsPerInterval: ").append(this.toIndentedString(this.averageAfterCallWorkSecondsPerInterval)).append("\n");
        sb.append("    completedPerInterval: ").append(this.toIndentedString(this.completedPerInterval)).append("\n");
        sb.append("    abandonedPerInterval: ").append(this.toIndentedString(this.abandonedPerInterval)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

