/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.HashMap;
import java.util.Map;

public class GetQualityFormRequest {
    private String formId;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getFormId() {
        return this.formId;
    }

    public void setFormId(String formId) {
        this.formId = formId;
    }

    public GetQualityFormRequest withFormId(String formId) {
        this.setFormId(formId);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public GetQualityFormRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        if (this.formId == null) {
            throw new IllegalStateException("Missing the required parameter 'formId' when building request for GetQualityFormRequest.");
        }
        return ApiRequestBuilder.create("GET", "/api/v2/quality/forms/{formId}").withPathParameter("formId", this.formId).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String formId) {
        return new Builder().withRequiredParams(formId);
    }

    public static class Builder {
        private final GetQualityFormRequest request = new GetQualityFormRequest();

        private Builder() {
        }

        public Builder withFormId(String formId) {
            this.request.setFormId(formId);
            return this;
        }

        public Builder withRequiredParams(String formId) {
            this.request.setFormId(formId);
            return this;
        }

        public GetQualityFormRequest build() {
            if (this.request.formId == null) {
                throw new IllegalStateException("Missing the required parameter 'formId' when building request for GetQualityFormRequest.");
            }
            return this.request;
        }
    }
}

