/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.model.UserScheduleFullDayTimeOffMarker;
import com.mypurecloud.sdk.v2.model.UserScheduleShift;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="A schedule for a single user over a given time range")
public class UserSchedule
implements Serializable {
    private List<UserScheduleShift> shifts = new ArrayList<UserScheduleShift>();
    private List<UserScheduleFullDayTimeOffMarker> fullDayTimeOffMarkers = new ArrayList<UserScheduleFullDayTimeOffMarker>();

    public UserSchedule shifts(List<UserScheduleShift> shifts) {
        this.shifts = shifts;
        return this;
    }

    @ApiModelProperty(example="null", value="The shifts that belong to this schedule")
    @JsonProperty(value="shifts")
    public List<UserScheduleShift> getShifts() {
        return this.shifts;
    }

    public void setShifts(List<UserScheduleShift> shifts) {
        this.shifts = shifts;
    }

    public UserSchedule fullDayTimeOffMarkers(List<UserScheduleFullDayTimeOffMarker> fullDayTimeOffMarkers) {
        this.fullDayTimeOffMarkers = fullDayTimeOffMarkers;
        return this;
    }

    @ApiModelProperty(example="null", value="Markers to indicate a full day time off request, relative to the management unit time zone")
    @JsonProperty(value="fullDayTimeOffMarkers")
    public List<UserScheduleFullDayTimeOffMarker> getFullDayTimeOffMarkers() {
        return this.fullDayTimeOffMarkers;
    }

    public void setFullDayTimeOffMarkers(List<UserScheduleFullDayTimeOffMarker> fullDayTimeOffMarkers) {
        this.fullDayTimeOffMarkers = fullDayTimeOffMarkers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserSchedule userSchedule = (UserSchedule)o;
        return Objects.equals(this.shifts, userSchedule.shifts) && Objects.equals(this.fullDayTimeOffMarkers, userSchedule.fullDayTimeOffMarkers);
    }

    public int hashCode() {
        return Objects.hash(this.shifts, this.fullDayTimeOffMarkers);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserSchedule {\n");
        sb.append("    shifts: ").append(this.toIndentedString(this.shifts)).append("\n");
        sb.append("    fullDayTimeOffMarkers: ").append(this.toIndentedString(this.fullDayTimeOffMarkers)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

