/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.model.Photo;
import com.mypurecloud.sdk.v2.model.ScimEmail;
import com.mypurecloud.sdk.v2.model.ScimMetadata;
import com.mypurecloud.sdk.v2.model.ScimPhoneNumber;
import com.mypurecloud.sdk.v2.model.ScimV2EnterpriseUser;
import com.mypurecloud.sdk.v2.model.ScimV2GroupReference;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Defines a SCIM user.")
public class ScimV2User
implements Serializable {
    private String id = null;
    private List<String> schemas = new ArrayList<String>();
    private Boolean active = null;
    private String userName = null;
    private String displayName = null;
    private String password = null;
    private String title = null;
    private List<ScimPhoneNumber> phoneNumbers = new ArrayList<ScimPhoneNumber>();
    private List<ScimEmail> emails = new ArrayList<ScimEmail>();
    private List<Photo> photos = new ArrayList<Photo>();
    private String externalId = null;
    private List<ScimV2GroupReference> groups = new ArrayList<ScimV2GroupReference>();
    private List<String> roles = new ArrayList<String>();
    private ScimV2EnterpriseUser urnietfparamsscimschemasextensionenterprise20User = null;
    private ScimMetadata meta = null;

    @ApiModelProperty(example="null", value="The ID of the SCIM resource. Set by the service provider. \"caseExact\" is set to \"true\". \"Mutability\" is set to \"readOnly\". \"Returned\" is set to \"always\".")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public ScimV2User schemas(List<String> schemas) {
        this.schemas = schemas;
        return this;
    }

    @ApiModelProperty(example="null", value="The list of supported schemas.")
    @JsonProperty(value="schemas")
    public List<String> getSchemas() {
        return this.schemas;
    }

    public void setSchemas(List<String> schemas) {
        this.schemas = schemas;
    }

    public ScimV2User active(Boolean active) {
        this.active = active;
        return this;
    }

    @ApiModelProperty(example="null", value="Indicates whether the user's administrative status is active.")
    @JsonProperty(value="active")
    public Boolean getActive() {
        return this.active;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public ScimV2User userName(String userName) {
        this.userName = userName;
        return this;
    }

    @ApiModelProperty(example="null", value="The user's PureCloud email address. Must be unique.")
    @JsonProperty(value="userName")
    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public ScimV2User displayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @ApiModelProperty(example="null", value="The display name of the user.")
    @JsonProperty(value="displayName")
    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public ScimV2User password(String password) {
        this.password = password;
        return this;
    }

    @ApiModelProperty(example="null", value="The new password for the PureCloud user. Does not return an existing password.")
    @JsonProperty(value="password")
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public ScimV2User title(String title) {
        this.title = title;
        return this;
    }

    @ApiModelProperty(example="null", value="The user's title.")
    @JsonProperty(value="title")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public ScimV2User phoneNumbers(List<ScimPhoneNumber> phoneNumbers) {
        this.phoneNumbers = phoneNumbers;
        return this;
    }

    @ApiModelProperty(example="null", value="The list of the user's phone numbers.")
    @JsonProperty(value="phoneNumbers")
    public List<ScimPhoneNumber> getPhoneNumbers() {
        return this.phoneNumbers;
    }

    public void setPhoneNumbers(List<ScimPhoneNumber> phoneNumbers) {
        this.phoneNumbers = phoneNumbers;
    }

    public ScimV2User emails(List<ScimEmail> emails) {
        this.emails = emails;
        return this;
    }

    @ApiModelProperty(example="null", value="The list of the user's email addresses.")
    @JsonProperty(value="emails")
    public List<ScimEmail> getEmails() {
        return this.emails;
    }

    public void setEmails(List<ScimEmail> emails) {
        this.emails = emails;
    }

    public ScimV2User photos(List<Photo> photos) {
        this.photos = photos;
        return this;
    }

    @ApiModelProperty(example="null", value="The list of the user's photos.")
    @JsonProperty(value="photos")
    public List<Photo> getPhotos() {
        return this.photos;
    }

    public void setPhotos(List<Photo> photos) {
        this.photos = photos;
    }

    public ScimV2User externalId(String externalId) {
        this.externalId = externalId;
        return this;
    }

    @ApiModelProperty(example="null", value="The external ID of the user. Set by the provisioning client. \"caseExact\" is set to \"true\". \"mutability\" is set to \"readWrite\".")
    @JsonProperty(value="externalId")
    public String getExternalId() {
        return this.externalId;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public ScimV2User groups(List<ScimV2GroupReference> groups) {
        this.groups = groups;
        return this;
    }

    @ApiModelProperty(example="null", value="The list of groups that the user is a member of.")
    @JsonProperty(value="groups")
    public List<ScimV2GroupReference> getGroups() {
        return this.groups;
    }

    public void setGroups(List<ScimV2GroupReference> groups) {
        this.groups = groups;
    }

    public ScimV2User roles(List<String> roles) {
        this.roles = roles;
        return this;
    }

    @ApiModelProperty(example="null", value="The list of roles assigned to the user.")
    @JsonProperty(value="roles")
    public List<String> getRoles() {
        return this.roles;
    }

    public void setRoles(List<String> roles) {
        this.roles = roles;
    }

    public ScimV2User urnietfparamsscimschemasextensionenterprise20User(ScimV2EnterpriseUser urnietfparamsscimschemasextensionenterprise20User) {
        this.urnietfparamsscimschemasextensionenterprise20User = urnietfparamsscimschemasextensionenterprise20User;
        return this;
    }

    @ApiModelProperty(example="null", value="The URI of the schema for the enterprise user.")
    @JsonProperty(value="urn:ietf:params:scim:schemas:extension:enterprise:2.0:User")
    public ScimV2EnterpriseUser getUrnietfparamsscimschemasextensionenterprise20User() {
        return this.urnietfparamsscimschemasextensionenterprise20User;
    }

    public void setUrnietfparamsscimschemasextensionenterprise20User(ScimV2EnterpriseUser urnietfparamsscimschemasextensionenterprise20User) {
        this.urnietfparamsscimschemasextensionenterprise20User = urnietfparamsscimschemasextensionenterprise20User;
    }

    public ScimV2User meta(ScimMetadata meta) {
        this.meta = meta;
        return this;
    }

    @ApiModelProperty(example="null", value="The metadata of the SCIM resource.")
    @JsonProperty(value="meta")
    public ScimMetadata getMeta() {
        return this.meta;
    }

    public void setMeta(ScimMetadata meta) {
        this.meta = meta;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScimV2User scimV2User = (ScimV2User)o;
        return Objects.equals(this.id, scimV2User.id) && Objects.equals(this.schemas, scimV2User.schemas) && Objects.equals(this.active, scimV2User.active) && Objects.equals(this.userName, scimV2User.userName) && Objects.equals(this.displayName, scimV2User.displayName) && Objects.equals(this.password, scimV2User.password) && Objects.equals(this.title, scimV2User.title) && Objects.equals(this.phoneNumbers, scimV2User.phoneNumbers) && Objects.equals(this.emails, scimV2User.emails) && Objects.equals(this.photos, scimV2User.photos) && Objects.equals(this.externalId, scimV2User.externalId) && Objects.equals(this.groups, scimV2User.groups) && Objects.equals(this.roles, scimV2User.roles) && Objects.equals(this.urnietfparamsscimschemasextensionenterprise20User, scimV2User.urnietfparamsscimschemasextensionenterprise20User) && Objects.equals(this.meta, scimV2User.meta);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.schemas, this.active, this.userName, this.displayName, this.password, this.title, this.phoneNumbers, this.emails, this.photos, this.externalId, this.groups, this.roles, this.urnietfparamsscimschemasextensionenterprise20User, this.meta);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ScimV2User {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    schemas: ").append(this.toIndentedString(this.schemas)).append("\n");
        sb.append("    active: ").append(this.toIndentedString(this.active)).append("\n");
        sb.append("    userName: ").append(this.toIndentedString(this.userName)).append("\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    password: ").append(this.toIndentedString(this.password)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    phoneNumbers: ").append(this.toIndentedString(this.phoneNumbers)).append("\n");
        sb.append("    emails: ").append(this.toIndentedString(this.emails)).append("\n");
        sb.append("    photos: ").append(this.toIndentedString(this.photos)).append("\n");
        sb.append("    externalId: ").append(this.toIndentedString(this.externalId)).append("\n");
        sb.append("    groups: ").append(this.toIndentedString(this.groups)).append("\n");
        sb.append("    roles: ").append(this.toIndentedString(this.roles)).append("\n");
        sb.append("    urnietfparamsscimschemasextensionenterprise20User: ").append(this.toIndentedString(this.urnietfparamsscimschemasextensionenterprise20User)).append("\n");
        sb.append("    meta: ").append(this.toIndentedString(this.meta)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

