/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.model.ScimV2PatchOperation;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Represents a SCIM V2 Patch Request (See RFC7644 for detailed usage)")
public class ScimV2PatchRequest
implements Serializable {
    private List<String> schemas = new ArrayList<String>();
    private List<ScimV2PatchOperation> operations = new ArrayList<ScimV2PatchOperation>();

    public ScimV2PatchRequest schemas(List<String> schemas) {
        this.schemas = schemas;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The list of schemas used in the PATCH request.")
    @JsonProperty(value="schemas")
    public List<String> getSchemas() {
        return this.schemas;
    }

    public void setSchemas(List<String> schemas) {
        this.schemas = schemas;
    }

    public ScimV2PatchRequest operations(List<ScimV2PatchOperation> operations) {
        this.operations = operations;
        return this;
    }

    @ApiModelProperty(example="null", value="The list of operations to perform for the PATCH request.")
    @JsonProperty(value="Operations")
    public List<ScimV2PatchOperation> getOperations() {
        return this.operations;
    }

    public void setOperations(List<ScimV2PatchOperation> operations) {
        this.operations = operations;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScimV2PatchRequest scimV2PatchRequest = (ScimV2PatchRequest)o;
        return Objects.equals(this.schemas, scimV2PatchRequest.schemas) && Objects.equals(this.operations, scimV2PatchRequest.operations);
    }

    public int hashCode() {
        return Objects.hash(this.schemas, this.operations);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ScimV2PatchRequest {\n");
        sb.append("    schemas: ").append(this.toIndentedString(this.schemas)).append("\n");
        sb.append("    operations: ").append(this.toIndentedString(this.operations)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

