/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.model.QueueReference;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="A combination of a single queue and one or more media types to associate with a service goal group")
public class QueueMediaAssociation
implements Serializable {
    private String id = null;
    private QueueReference queue = null;
    private List<MediaTypesEnum> mediaTypes = new ArrayList<MediaTypesEnum>();
    private Boolean delete = null;

    @ApiModelProperty(example="null", value="The reference ID for this QueueMediaAssociation")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public QueueMediaAssociation queue(QueueReference queue) {
        this.queue = queue;
        return this;
    }

    @ApiModelProperty(example="null", value="The queue to associate with the service goal group")
    @JsonProperty(value="queue")
    public QueueReference getQueue() {
        return this.queue;
    }

    public void setQueue(QueueReference queue) {
        this.queue = queue;
    }

    public QueueMediaAssociation mediaTypes(List<MediaTypesEnum> mediaTypes) {
        this.mediaTypes = mediaTypes;
        return this;
    }

    @ApiModelProperty(example="null", value="The media types of the given queue to associate with the service goal group")
    @JsonProperty(value="mediaTypes")
    public List<MediaTypesEnum> getMediaTypes() {
        return this.mediaTypes;
    }

    public void setMediaTypes(List<MediaTypesEnum> mediaTypes) {
        this.mediaTypes = mediaTypes;
    }

    public QueueMediaAssociation delete(Boolean delete) {
        this.delete = delete;
        return this;
    }

    @ApiModelProperty(example="null", value="If marked true on a PATCH, this QueueMediaAssociation will be permanently deleted")
    @JsonProperty(value="delete")
    public Boolean getDelete() {
        return this.delete;
    }

    public void setDelete(Boolean delete) {
        this.delete = delete;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueueMediaAssociation queueMediaAssociation = (QueueMediaAssociation)o;
        return Objects.equals(this.id, queueMediaAssociation.id) && Objects.equals(this.queue, queueMediaAssociation.queue) && Objects.equals(this.mediaTypes, queueMediaAssociation.mediaTypes) && Objects.equals(this.delete, queueMediaAssociation.delete);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.queue, this.mediaTypes, this.delete);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class QueueMediaAssociation {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    queue: ").append(this.toIndentedString(this.queue)).append("\n");
        sb.append("    mediaTypes: ").append(this.toIndentedString(this.mediaTypes)).append("\n");
        sb.append("    delete: ").append(this.toIndentedString(this.delete)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum MediaTypesEnum {
        VOICE("Voice"),
        CHAT("Chat"),
        EMAIL("Email"),
        CALLBACK("Callback"),
        MESSAGE("Message");

        private String value;

        private MediaTypesEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static MediaTypesEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (MediaTypesEnum value : MediaTypesEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return MediaTypesEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

