/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.model.AsyncConversationQuery;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

public class RecordingJobsQuery
implements Serializable {
    private ActionEnum action = null;
    private Date actionDate = null;
    private String integrationId = null;
    private Boolean includeScreenRecordings = null;
    private AsyncConversationQuery conversationQuery = null;

    public RecordingJobsQuery action(ActionEnum action) {
        this.action = action;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Operation to perform bulk task")
    @JsonProperty(value="action")
    public ActionEnum getAction() {
        return this.action;
    }

    public void setAction(ActionEnum action) {
        this.action = action;
    }

    public RecordingJobsQuery actionDate(Date actionDate) {
        this.actionDate = actionDate;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The date when the action will be performed. If the operation will cause the delete date of a recording to be older than the export date, the export date will be adjusted to the delete date. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ")
    @JsonProperty(value="actionDate")
    public Date getActionDate() {
        return this.actionDate;
    }

    public void setActionDate(Date actionDate) {
        this.actionDate = actionDate;
    }

    public RecordingJobsQuery integrationId(String integrationId) {
        this.integrationId = integrationId;
        return this;
    }

    @ApiModelProperty(example="null", value="IntegrationId to Access AWS S3 bucket for bulk recording exports. This field is for EXPORT only")
    @JsonProperty(value="integrationId")
    public String getIntegrationId() {
        return this.integrationId;
    }

    public void setIntegrationId(String integrationId) {
        this.integrationId = integrationId;
    }

    public RecordingJobsQuery includeScreenRecordings(Boolean includeScreenRecordings) {
        this.includeScreenRecordings = includeScreenRecordings;
        return this;
    }

    @ApiModelProperty(example="null", value="Include Screen recordings for export action, default value = true ")
    @JsonProperty(value="includeScreenRecordings")
    public Boolean getIncludeScreenRecordings() {
        return this.includeScreenRecordings;
    }

    public void setIncludeScreenRecordings(Boolean includeScreenRecordings) {
        this.includeScreenRecordings = includeScreenRecordings;
    }

    public RecordingJobsQuery conversationQuery(AsyncConversationQuery conversationQuery) {
        this.conversationQuery = conversationQuery;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Conversation Query. Note: After the recording is created, it might take up to 48 hours for the recording to be included in the submitted job query.")
    @JsonProperty(value="conversationQuery")
    public AsyncConversationQuery getConversationQuery() {
        return this.conversationQuery;
    }

    public void setConversationQuery(AsyncConversationQuery conversationQuery) {
        this.conversationQuery = conversationQuery;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RecordingJobsQuery recordingJobsQuery = (RecordingJobsQuery)o;
        return Objects.equals((Object)this.action, (Object)recordingJobsQuery.action) && Objects.equals(this.actionDate, recordingJobsQuery.actionDate) && Objects.equals(this.integrationId, recordingJobsQuery.integrationId) && Objects.equals(this.includeScreenRecordings, recordingJobsQuery.includeScreenRecordings) && Objects.equals(this.conversationQuery, recordingJobsQuery.conversationQuery);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.action, this.actionDate, this.integrationId, this.includeScreenRecordings, this.conversationQuery});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RecordingJobsQuery {\n");
        sb.append("    action: ").append(this.toIndentedString((Object)this.action)).append("\n");
        sb.append("    actionDate: ").append(this.toIndentedString(this.actionDate)).append("\n");
        sb.append("    integrationId: ").append(this.toIndentedString(this.integrationId)).append("\n");
        sb.append("    includeScreenRecordings: ").append(this.toIndentedString(this.includeScreenRecordings)).append("\n");
        sb.append("    conversationQuery: ").append(this.toIndentedString(this.conversationQuery)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ActionEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        DELETE("DELETE"),
        EXPORT("EXPORT");

        private String value;

        private ActionEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ActionEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ActionEnum value : ActionEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ActionEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

