/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.JsonNode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;

@ApiModel(description="Represents an individual PATCH operation. Path and value have very specific rules based on operation type. See https://tools.ietf.org/html/rfc7644#section-3.5.2 for details.")
public class ScimV2PatchOperation
implements Serializable {
    private OpEnum op = null;
    private String path = null;
    private JsonNode value = null;

    public ScimV2PatchOperation op(OpEnum op) {
        this.op = op;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The PATCH operation to perform.")
    @JsonProperty(value="op")
    public OpEnum getOp() {
        return this.op;
    }

    public void setOp(OpEnum op) {
        this.op = op;
    }

    public ScimV2PatchOperation path(String path) {
        this.path = path;
        return this;
    }

    @ApiModelProperty(example="null", value="The attribute path that describes the target of the operation. Required for a \"remove\" operation.")
    @JsonProperty(value="path")
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public ScimV2PatchOperation value(JsonNode value) {
        this.value = value;
        return this;
    }

    @ApiModelProperty(example="null", value="The value to set in the path.")
    @JsonProperty(value="value")
    public JsonNode getValue() {
        return this.value;
    }

    public void setValue(JsonNode value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScimV2PatchOperation scimV2PatchOperation = (ScimV2PatchOperation)o;
        return Objects.equals((Object)this.op, (Object)scimV2PatchOperation.op) && Objects.equals(this.path, scimV2PatchOperation.path) && Objects.equals(this.value, scimV2PatchOperation.value);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.op, this.path, this.value});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ScimV2PatchOperation {\n");
        sb.append("    op: ").append(this.toIndentedString((Object)this.op)).append("\n");
        sb.append("    path: ").append(this.toIndentedString(this.path)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum OpEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ADD("add"),
        REPLACE("replace"),
        REMOVE("remove");

        private String value;

        private OpEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static OpEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (OpEnum value : OpEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return OpEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

