/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.model.ScimConfigResourceTypeSchemaExtension;
import com.mypurecloud.sdk.v2.model.ScimMetadata;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Common attributes to all SCIM resources")
public class ScimConfigResourceType
implements Serializable {
    private String id = null;
    private List<String> schemas = new ArrayList<String>();
    private String name = null;
    private String description = null;
    private String schema = null;
    private List<ScimConfigResourceTypeSchemaExtension> schemaExtensions = new ArrayList<ScimConfigResourceTypeSchemaExtension>();
    private String endpoint = null;
    private ScimMetadata meta = null;

    @ApiModelProperty(example="null", value="The ID of the SCIM resource. Set by the service provider. caseExact is set to true. Mutability is set to readOnly. Returned is set to always.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public ScimConfigResourceType schemas(List<String> schemas) {
        this.schemas = schemas;
        return this;
    }

    @ApiModelProperty(example="null", value="schemas supported")
    @JsonProperty(value="schemas")
    public List<String> getSchemas() {
        return this.schemas;
    }

    public void setSchemas(List<String> schemas) {
        this.schemas = schemas;
    }

    @ApiModelProperty(example="null", value="Resource name.")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @ApiModelProperty(example="null", value="Resource description.")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @ApiModelProperty(example="null", value="The resource type's primary/base schema URI.")
    @JsonProperty(value="schema")
    public String getSchema() {
        return this.schema;
    }

    public ScimConfigResourceType schemaExtensions(List<ScimConfigResourceTypeSchemaExtension> schemaExtensions) {
        this.schemaExtensions = schemaExtensions;
        return this;
    }

    @ApiModelProperty(example="null", value="Resource extension schemas")
    @JsonProperty(value="schemaExtensions")
    public List<ScimConfigResourceTypeSchemaExtension> getSchemaExtensions() {
        return this.schemaExtensions;
    }

    public void setSchemaExtensions(List<ScimConfigResourceTypeSchemaExtension> schemaExtensions) {
        this.schemaExtensions = schemaExtensions;
    }

    @ApiModelProperty(example="null", value="Resource HTTP endpoint.")
    @JsonProperty(value="endpoint")
    public String getEndpoint() {
        return this.endpoint;
    }

    public ScimConfigResourceType meta(ScimMetadata meta) {
        this.meta = meta;
        return this;
    }

    @ApiModelProperty(example="null", value="Resource SCIM meta")
    @JsonProperty(value="meta")
    public ScimMetadata getMeta() {
        return this.meta;
    }

    public void setMeta(ScimMetadata meta) {
        this.meta = meta;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScimConfigResourceType scimConfigResourceType = (ScimConfigResourceType)o;
        return Objects.equals(this.id, scimConfigResourceType.id) && Objects.equals(this.schemas, scimConfigResourceType.schemas) && Objects.equals(this.name, scimConfigResourceType.name) && Objects.equals(this.description, scimConfigResourceType.description) && Objects.equals(this.schema, scimConfigResourceType.schema) && Objects.equals(this.schemaExtensions, scimConfigResourceType.schemaExtensions) && Objects.equals(this.endpoint, scimConfigResourceType.endpoint) && Objects.equals(this.meta, scimConfigResourceType.meta);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.schemas, this.name, this.description, this.schema, this.schemaExtensions, this.endpoint, this.meta);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ScimConfigResourceType {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    schemas: ").append(this.toIndentedString(this.schemas)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    schema: ").append(this.toIndentedString(this.schema)).append("\n");
        sb.append("    schemaExtensions: ").append(this.toIndentedString(this.schemaExtensions)).append("\n");
        sb.append("    endpoint: ").append(this.toIndentedString(this.endpoint)).append("\n");
        sb.append("    meta: ").append(this.toIndentedString(this.meta)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

