/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class InboundMessageRequest
implements Serializable {
    private String queueId = null;
    private String flowId = null;
    private String provider = null;
    private List<String> skillIds = new ArrayList<String>();
    private String languageId = null;
    private Integer priority = null;
    private Map<String, String> attributes = null;
    private String toAddress = null;
    private String toName = null;
    private String fromAddress = null;
    private String fromName = null;
    private String subject = null;

    public InboundMessageRequest queueId(String queueId) {
        this.queueId = queueId;
        return this;
    }

    @ApiModelProperty(example="null", value="The ID of the queue to use for routing the email conversation. This field is mutually exclusive with flowId")
    @JsonProperty(value="queueId")
    public String getQueueId() {
        return this.queueId;
    }

    public void setQueueId(String queueId) {
        this.queueId = queueId;
    }

    public InboundMessageRequest flowId(String flowId) {
        this.flowId = flowId;
        return this;
    }

    @ApiModelProperty(example="null", value="The ID of the flow to use for routing email conversation. This field is mutually exclusive with queueId")
    @JsonProperty(value="flowId")
    public String getFlowId() {
        return this.flowId;
    }

    public void setFlowId(String flowId) {
        this.flowId = flowId;
    }

    public InboundMessageRequest provider(String provider) {
        this.provider = provider;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The name of the provider that is sourcing the email such as Oracle, Salesforce, etc.")
    @JsonProperty(value="provider")
    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public InboundMessageRequest skillIds(List<String> skillIds) {
        this.skillIds = skillIds;
        return this;
    }

    @ApiModelProperty(example="null", value="The list of skill ID's to use for routing.")
    @JsonProperty(value="skillIds")
    public List<String> getSkillIds() {
        return this.skillIds;
    }

    public void setSkillIds(List<String> skillIds) {
        this.skillIds = skillIds;
    }

    public InboundMessageRequest languageId(String languageId) {
        this.languageId = languageId;
        return this;
    }

    @ApiModelProperty(example="null", value="The ID of the language to use for routing.")
    @JsonProperty(value="languageId")
    public String getLanguageId() {
        return this.languageId;
    }

    public void setLanguageId(String languageId) {
        this.languageId = languageId;
    }

    public InboundMessageRequest priority(Integer priority) {
        this.priority = priority;
        return this;
    }

    @ApiModelProperty(example="null", value="The priority to assign to the conversation for routing.")
    @JsonProperty(value="priority")
    public Integer getPriority() {
        return this.priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public InboundMessageRequest attributes(Map<String, String> attributes) {
        this.attributes = attributes;
        return this;
    }

    @ApiModelProperty(example="null", value="The list of attributes to associate with the customer participant.")
    @JsonProperty(value="attributes")
    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public InboundMessageRequest toAddress(String toAddress) {
        this.toAddress = toAddress;
        return this;
    }

    @ApiModelProperty(example="null", value="The email address of the recipient of the email.")
    @JsonProperty(value="toAddress")
    public String getToAddress() {
        return this.toAddress;
    }

    public void setToAddress(String toAddress) {
        this.toAddress = toAddress;
    }

    public InboundMessageRequest toName(String toName) {
        this.toName = toName;
        return this;
    }

    @ApiModelProperty(example="null", value="The name of the recipient of the email.")
    @JsonProperty(value="toName")
    public String getToName() {
        return this.toName;
    }

    public void setToName(String toName) {
        this.toName = toName;
    }

    public InboundMessageRequest fromAddress(String fromAddress) {
        this.fromAddress = fromAddress;
        return this;
    }

    @ApiModelProperty(example="null", value="The email address of the sender of the email.")
    @JsonProperty(value="fromAddress")
    public String getFromAddress() {
        return this.fromAddress;
    }

    public void setFromAddress(String fromAddress) {
        this.fromAddress = fromAddress;
    }

    public InboundMessageRequest fromName(String fromName) {
        this.fromName = fromName;
        return this;
    }

    @ApiModelProperty(example="null", value="The name of the sender of the email.")
    @JsonProperty(value="fromName")
    public String getFromName() {
        return this.fromName;
    }

    public void setFromName(String fromName) {
        this.fromName = fromName;
    }

    public InboundMessageRequest subject(String subject) {
        this.subject = subject;
        return this;
    }

    @ApiModelProperty(example="null", value="The subject of the email")
    @JsonProperty(value="subject")
    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InboundMessageRequest inboundMessageRequest = (InboundMessageRequest)o;
        return Objects.equals(this.queueId, inboundMessageRequest.queueId) && Objects.equals(this.flowId, inboundMessageRequest.flowId) && Objects.equals(this.provider, inboundMessageRequest.provider) && Objects.equals(this.skillIds, inboundMessageRequest.skillIds) && Objects.equals(this.languageId, inboundMessageRequest.languageId) && Objects.equals(this.priority, inboundMessageRequest.priority) && Objects.equals(this.attributes, inboundMessageRequest.attributes) && Objects.equals(this.toAddress, inboundMessageRequest.toAddress) && Objects.equals(this.toName, inboundMessageRequest.toName) && Objects.equals(this.fromAddress, inboundMessageRequest.fromAddress) && Objects.equals(this.fromName, inboundMessageRequest.fromName) && Objects.equals(this.subject, inboundMessageRequest.subject);
    }

    public int hashCode() {
        return Objects.hash(this.queueId, this.flowId, this.provider, this.skillIds, this.languageId, this.priority, this.attributes, this.toAddress, this.toName, this.fromAddress, this.fromName, this.subject);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InboundMessageRequest {\n");
        sb.append("    queueId: ").append(this.toIndentedString(this.queueId)).append("\n");
        sb.append("    flowId: ").append(this.toIndentedString(this.flowId)).append("\n");
        sb.append("    provider: ").append(this.toIndentedString(this.provider)).append("\n");
        sb.append("    skillIds: ").append(this.toIndentedString(this.skillIds)).append("\n");
        sb.append("    languageId: ").append(this.toIndentedString(this.languageId)).append("\n");
        sb.append("    priority: ").append(this.toIndentedString(this.priority)).append("\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    toAddress: ").append(this.toIndentedString(this.toAddress)).append("\n");
        sb.append("    toName: ").append(this.toIndentedString(this.toName)).append("\n");
        sb.append("    fromAddress: ").append(this.toIndentedString(this.fromAddress)).append("\n");
        sb.append("    fromName: ").append(this.toIndentedString(this.fromName)).append("\n");
        sb.append("    subject: ").append(this.toIndentedString(this.subject)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

