/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.HashMap;
import java.util.Map;

public class GetScimV2GroupRequest {
    private String groupId;
    private String ifNoneMatch;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public GetScimV2GroupRequest withGroupId(String groupId) {
        this.setGroupId(groupId);
        return this;
    }

    public String getIfNoneMatch() {
        return this.ifNoneMatch;
    }

    public void setIfNoneMatch(String ifNoneMatch) {
        this.ifNoneMatch = ifNoneMatch;
    }

    public GetScimV2GroupRequest withIfNoneMatch(String ifNoneMatch) {
        this.setIfNoneMatch(ifNoneMatch);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public GetScimV2GroupRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        if (this.groupId == null) {
            throw new IllegalStateException("Missing the required parameter 'groupId' when building request for GetScimV2GroupRequest.");
        }
        return ApiRequestBuilder.create("GET", "/api/v2/scim/v2/groups/{groupId}").withPathParameter("groupId", this.groupId).withHeaderParameter("If-None-Match", this.ifNoneMatch).withCustomHeaders(this.customHeaders).withContentTypes("application/json", "application/scim+json").withAccepts("application/json", "application/scim+json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String groupId) {
        return new Builder().withRequiredParams(groupId);
    }

    public static class Builder {
        private final GetScimV2GroupRequest request = new GetScimV2GroupRequest();

        private Builder() {
        }

        public Builder withGroupId(String groupId) {
            this.request.setGroupId(groupId);
            return this;
        }

        public Builder withIfNoneMatch(String ifNoneMatch) {
            this.request.setIfNoneMatch(ifNoneMatch);
            return this;
        }

        public Builder withRequiredParams(String groupId) {
            this.request.setGroupId(groupId);
            return this;
        }

        public GetScimV2GroupRequest build() {
            if (this.request.groupId == null) {
                throw new IllegalStateException("Missing the required parameter 'groupId' when building request for GetScimV2GroupRequest.");
            }
            return this.request;
        }
    }
}

