/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.model.Photo;
import com.mypurecloud.sdk.v2.model.ScimEmail;
import com.mypurecloud.sdk.v2.model.ScimMetadata;
import com.mypurecloud.sdk.v2.model.ScimPhoneNumber;
import com.mypurecloud.sdk.v2.model.ScimV2EnterpriseUser;
import com.mypurecloud.sdk.v2.model.ScimV2GroupReference;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Represents a SCIM V2 Enterprise Manager")
public class Manager
implements Serializable {
    private String displayName = null;
    private Boolean active = null;
    private String userName = null;
    private String password = null;
    private String title = null;
    private List<ScimPhoneNumber> phoneNumbers = new ArrayList<ScimPhoneNumber>();
    private List<ScimEmail> emails = new ArrayList<ScimEmail>();
    private List<Photo> photos = new ArrayList<Photo>();
    private String externalId = null;
    private List<ScimV2GroupReference> groups = new ArrayList<ScimV2GroupReference>();
    private ScimMetadata meta = null;
    private ScimV2EnterpriseUser urnietfparamsscimschemasextensionenterprise20User = null;
    private String value = null;
    private String ref = null;

    public Manager displayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @ApiModelProperty(example="null", value="Display Name")
    @JsonProperty(value="displayName")
    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public Manager active(Boolean active) {
        this.active = active;
        return this;
    }

    @ApiModelProperty(example="null", value="Active flag")
    @JsonProperty(value="active")
    public Boolean getActive() {
        return this.active;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public Manager userName(String userName) {
        this.userName = userName;
        return this;
    }

    @ApiModelProperty(example="null", value="User Name (Must be Unique) maps to PureCloud e-mail address")
    @JsonProperty(value="userName")
    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public Manager password(String password) {
        this.password = password;
        return this;
    }

    @ApiModelProperty(example="null", value="Password (updateOnly)")
    @JsonProperty(value="password")
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Manager title(String title) {
        this.title = title;
        return this;
    }

    @ApiModelProperty(example="null", value="Title")
    @JsonProperty(value="title")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Manager phoneNumbers(List<ScimPhoneNumber> phoneNumbers) {
        this.phoneNumbers = phoneNumbers;
        return this;
    }

    @ApiModelProperty(example="null", value="Phone numbers")
    @JsonProperty(value="phoneNumbers")
    public List<ScimPhoneNumber> getPhoneNumbers() {
        return this.phoneNumbers;
    }

    public void setPhoneNumbers(List<ScimPhoneNumber> phoneNumbers) {
        this.phoneNumbers = phoneNumbers;
    }

    public Manager emails(List<ScimEmail> emails) {
        this.emails = emails;
        return this;
    }

    @ApiModelProperty(example="null", value="Emails")
    @JsonProperty(value="emails")
    public List<ScimEmail> getEmails() {
        return this.emails;
    }

    public void setEmails(List<ScimEmail> emails) {
        this.emails = emails;
    }

    public Manager photos(List<Photo> photos) {
        this.photos = photos;
        return this;
    }

    @ApiModelProperty(example="null", value="Photos")
    @JsonProperty(value="photos")
    public List<Photo> getPhotos() {
        return this.photos;
    }

    public void setPhotos(List<Photo> photos) {
        this.photos = photos;
    }

    public Manager externalId(String externalId) {
        this.externalId = externalId;
        return this;
    }

    @ApiModelProperty(example="null", value="External ID")
    @JsonProperty(value="externalId")
    public String getExternalId() {
        return this.externalId;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public Manager groups(List<ScimV2GroupReference> groups) {
        this.groups = groups;
        return this;
    }

    @ApiModelProperty(example="null", value="Group References")
    @JsonProperty(value="groups")
    public List<ScimV2GroupReference> getGroups() {
        return this.groups;
    }

    public void setGroups(List<ScimV2GroupReference> groups) {
        this.groups = groups;
    }

    public Manager meta(ScimMetadata meta) {
        this.meta = meta;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="meta")
    public ScimMetadata getMeta() {
        return this.meta;
    }

    public void setMeta(ScimMetadata meta) {
        this.meta = meta;
    }

    public Manager urnietfparamsscimschemasextensionenterprise20User(ScimV2EnterpriseUser urnietfparamsscimschemasextensionenterprise20User) {
        this.urnietfparamsscimschemasextensionenterprise20User = urnietfparamsscimschemasextensionenterprise20User;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="urn:ietf:params:scim:schemas:extension:enterprise:2.0:User")
    public ScimV2EnterpriseUser getUrnietfparamsscimschemasextensionenterprise20User() {
        return this.urnietfparamsscimschemasextensionenterprise20User;
    }

    public void setUrnietfparamsscimschemasextensionenterprise20User(ScimV2EnterpriseUser urnietfparamsscimschemasextensionenterprise20User) {
        this.urnietfparamsscimschemasextensionenterprise20User = urnietfparamsscimschemasextensionenterprise20User;
    }

    public Manager value(String value) {
        this.value = value;
        return this;
    }

    @ApiModelProperty(example="null", value="Identifier of the Manager")
    @JsonProperty(value="value")
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @ApiModelProperty(example="null", value="Ref to entity")
    @JsonProperty(value="$ref")
    public String getRef() {
        return this.ref;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Manager manager = (Manager)o;
        return Objects.equals(this.displayName, manager.displayName) && Objects.equals(this.active, manager.active) && Objects.equals(this.userName, manager.userName) && Objects.equals(this.password, manager.password) && Objects.equals(this.title, manager.title) && Objects.equals(this.phoneNumbers, manager.phoneNumbers) && Objects.equals(this.emails, manager.emails) && Objects.equals(this.photos, manager.photos) && Objects.equals(this.externalId, manager.externalId) && Objects.equals(this.groups, manager.groups) && Objects.equals(this.meta, manager.meta) && Objects.equals(this.urnietfparamsscimschemasextensionenterprise20User, manager.urnietfparamsscimschemasextensionenterprise20User) && Objects.equals(this.value, manager.value) && Objects.equals(this.ref, manager.ref);
    }

    public int hashCode() {
        return Objects.hash(this.displayName, this.active, this.userName, this.password, this.title, this.phoneNumbers, this.emails, this.photos, this.externalId, this.groups, this.meta, this.urnietfparamsscimschemasextensionenterprise20User, this.value, this.ref);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Manager {\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    active: ").append(this.toIndentedString(this.active)).append("\n");
        sb.append("    userName: ").append(this.toIndentedString(this.userName)).append("\n");
        sb.append("    password: ").append(this.toIndentedString(this.password)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    phoneNumbers: ").append(this.toIndentedString(this.phoneNumbers)).append("\n");
        sb.append("    emails: ").append(this.toIndentedString(this.emails)).append("\n");
        sb.append("    photos: ").append(this.toIndentedString(this.photos)).append("\n");
        sb.append("    externalId: ").append(this.toIndentedString(this.externalId)).append("\n");
        sb.append("    groups: ").append(this.toIndentedString(this.groups)).append("\n");
        sb.append("    meta: ").append(this.toIndentedString(this.meta)).append("\n");
        sb.append("    urnietfparamsscimschemasextensionenterprise20User: ").append(this.toIndentedString(this.urnietfparamsscimschemasextensionenterprise20User)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    ref: ").append(this.toIndentedString(this.ref)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

