/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.model.UriReference;
import com.mypurecloud.sdk.v2.model.WidgetClientConfig;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class WidgetDeployment
implements Serializable {
    private String id = null;
    private String name = null;
    private String description = null;
    private Boolean authenticationRequired = null;
    private Boolean disabled = null;
    private UriReference flow = null;
    private List<String> allowedDomains = new ArrayList<String>();
    private ClientTypeEnum clientType = null;
    private WidgetClientConfig clientConfig = null;
    private String selfUri = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public WidgetDeployment name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public WidgetDeployment description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="null", value="A human-readable description of this Deployment.")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public WidgetDeployment authenticationRequired(Boolean authenticationRequired) {
        this.authenticationRequired = authenticationRequired;
        return this;
    }

    @ApiModelProperty(example="null", value="When true, the customer members starting a chat must be authenticated by supplying their JWT to the create operation.")
    @JsonProperty(value="authenticationRequired")
    public Boolean getAuthenticationRequired() {
        return this.authenticationRequired;
    }

    public void setAuthenticationRequired(Boolean authenticationRequired) {
        this.authenticationRequired = authenticationRequired;
    }

    public WidgetDeployment disabled(Boolean disabled) {
        this.disabled = disabled;
        return this;
    }

    @ApiModelProperty(example="null", value="When true, all create chat operations using this Deployment will be rejected.")
    @JsonProperty(value="disabled")
    public Boolean getDisabled() {
        return this.disabled;
    }

    public void setDisabled(Boolean disabled) {
        this.disabled = disabled;
    }

    public WidgetDeployment flow(UriReference flow) {
        this.flow = flow;
        return this;
    }

    @ApiModelProperty(example="null", value="The URI of the Inbound Chat Flow to run when new chats are initiated under this Deployment.")
    @JsonProperty(value="flow")
    public UriReference getFlow() {
        return this.flow;
    }

    public void setFlow(UriReference flow) {
        this.flow = flow;
    }

    public WidgetDeployment allowedDomains(List<String> allowedDomains) {
        this.allowedDomains = allowedDomains;
        return this;
    }

    @ApiModelProperty(example="null", value="The list of domains that are approved to use this Deployment; the list will be added to CORS headers for ease of web use.")
    @JsonProperty(value="allowedDomains")
    public List<String> getAllowedDomains() {
        return this.allowedDomains;
    }

    public void setAllowedDomains(List<String> allowedDomains) {
        this.allowedDomains = allowedDomains;
    }

    public WidgetDeployment clientType(ClientTypeEnum clientType) {
        this.clientType = clientType;
        return this;
    }

    @ApiModelProperty(example="null", value="The type of display widget for which this Deployment is configured, which controls the administrator settings shown.")
    @JsonProperty(value="clientType")
    public ClientTypeEnum getClientType() {
        return this.clientType;
    }

    public void setClientType(ClientTypeEnum clientType) {
        this.clientType = clientType;
    }

    public WidgetDeployment clientConfig(WidgetClientConfig clientConfig) {
        this.clientConfig = clientConfig;
        return this;
    }

    @ApiModelProperty(example="null", value="The client configuration options that should be made available to the clients of this Deployment.")
    @JsonProperty(value="clientConfig")
    public WidgetClientConfig getClientConfig() {
        return this.clientConfig;
    }

    public void setClientConfig(WidgetClientConfig clientConfig) {
        this.clientConfig = clientConfig;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WidgetDeployment widgetDeployment = (WidgetDeployment)o;
        return Objects.equals(this.id, widgetDeployment.id) && Objects.equals(this.name, widgetDeployment.name) && Objects.equals(this.description, widgetDeployment.description) && Objects.equals(this.authenticationRequired, widgetDeployment.authenticationRequired) && Objects.equals(this.disabled, widgetDeployment.disabled) && Objects.equals(this.flow, widgetDeployment.flow) && Objects.equals(this.allowedDomains, widgetDeployment.allowedDomains) && Objects.equals((Object)this.clientType, (Object)widgetDeployment.clientType) && Objects.equals(this.clientConfig, widgetDeployment.clientConfig) && Objects.equals(this.selfUri, widgetDeployment.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.description, this.authenticationRequired, this.disabled, this.flow, this.allowedDomains, this.clientType, this.clientConfig, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WidgetDeployment {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    authenticationRequired: ").append(this.toIndentedString(this.authenticationRequired)).append("\n");
        sb.append("    disabled: ").append(this.toIndentedString(this.disabled)).append("\n");
        sb.append("    flow: ").append(this.toIndentedString(this.flow)).append("\n");
        sb.append("    allowedDomains: ").append(this.toIndentedString(this.allowedDomains)).append("\n");
        sb.append("    clientType: ").append(this.toIndentedString((Object)this.clientType)).append("\n");
        sb.append("    clientConfig: ").append(this.toIndentedString(this.clientConfig)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ClientTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        V1("v1"),
        V2("v2"),
        THIRD_PARTY("third-party");

        private String value;

        private ClientTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ClientTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ClientTypeEnum value : ClientTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ClientTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

