/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.model.Flow;
import com.mypurecloud.sdk.v2.model.User;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

public class Recipient
implements Serializable {
    private String id = null;
    private String name = null;
    private Flow flow = null;
    private Date dateCreated = null;
    private Date dateModified = null;
    private User createdBy = null;
    private User modifiedBy = null;
    private MessengerTypeEnum messengerType = null;
    private String selfUri = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public Recipient name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Recipient flow(Flow flow) {
        this.flow = flow;
        return this;
    }

    @ApiModelProperty(example="null", value="An automate flow object which defines the set of actions to be taken, when a message is received by this provisioned phone number.")
    @JsonProperty(value="flow")
    public Flow getFlow() {
        return this.flow;
    }

    public void setFlow(Flow flow) {
        this.flow = flow;
    }

    public Recipient dateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
        return this;
    }

    @ApiModelProperty(example="null", value="Date this recipient was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ")
    @JsonProperty(value="dateCreated")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    public Recipient dateModified(Date dateModified) {
        this.dateModified = dateModified;
        return this;
    }

    @ApiModelProperty(example="null", value="Date this recipient was modified. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ")
    @JsonProperty(value="dateModified")
    public Date getDateModified() {
        return this.dateModified;
    }

    public void setDateModified(Date dateModified) {
        this.dateModified = dateModified;
    }

    public Recipient createdBy(User createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    @ApiModelProperty(example="null", value="User that created this recipient")
    @JsonProperty(value="createdBy")
    public User getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(User createdBy) {
        this.createdBy = createdBy;
    }

    public Recipient modifiedBy(User modifiedBy) {
        this.modifiedBy = modifiedBy;
        return this;
    }

    @ApiModelProperty(example="null", value="User that modified this recipient")
    @JsonProperty(value="modifiedBy")
    public User getModifiedBy() {
        return this.modifiedBy;
    }

    public void setModifiedBy(User modifiedBy) {
        this.modifiedBy = modifiedBy;
    }

    public Recipient messengerType(MessengerTypeEnum messengerType) {
        this.messengerType = messengerType;
        return this;
    }

    @ApiModelProperty(example="null", value="The messenger type for this recipient")
    @JsonProperty(value="messengerType")
    public MessengerTypeEnum getMessengerType() {
        return this.messengerType;
    }

    public void setMessengerType(MessengerTypeEnum messengerType) {
        this.messengerType = messengerType;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Recipient recipient = (Recipient)o;
        return Objects.equals(this.id, recipient.id) && Objects.equals(this.name, recipient.name) && Objects.equals(this.flow, recipient.flow) && Objects.equals(this.dateCreated, recipient.dateCreated) && Objects.equals(this.dateModified, recipient.dateModified) && Objects.equals(this.createdBy, recipient.createdBy) && Objects.equals(this.modifiedBy, recipient.modifiedBy) && Objects.equals((Object)this.messengerType, (Object)recipient.messengerType) && Objects.equals(this.selfUri, recipient.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.flow, this.dateCreated, this.dateModified, this.createdBy, this.modifiedBy, this.messengerType, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Recipient {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    flow: ").append(this.toIndentedString(this.flow)).append("\n");
        sb.append("    dateCreated: ").append(this.toIndentedString(this.dateCreated)).append("\n");
        sb.append("    dateModified: ").append(this.toIndentedString(this.dateModified)).append("\n");
        sb.append("    createdBy: ").append(this.toIndentedString(this.createdBy)).append("\n");
        sb.append("    modifiedBy: ").append(this.toIndentedString(this.modifiedBy)).append("\n");
        sb.append("    messengerType: ").append(this.toIndentedString((Object)this.messengerType)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum MessengerTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        SMS("sms"),
        FACEBOOK("facebook"),
        TWITTER("twitter"),
        LINE("line"),
        WHATSAPP("whatsapp"),
        TELEGRAM("telegram"),
        KAKAO("kakao");

        private String value;

        private MessengerTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static MessengerTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (MessengerTypeEnum value : MessengerTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return MessengerTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

