/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.model.JourneyAction;
import com.mypurecloud.sdk.v2.model.JourneyCustomer;
import com.mypurecloud.sdk.v2.model.JourneyCustomerSession;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;

public class JourneyContext
implements Serializable {
    private JourneyCustomer customer = null;
    private JourneyCustomerSession customerSession = null;
    private JourneyAction triggeringAction = null;

    public JourneyContext customer(JourneyCustomer customer) {
        this.customer = customer;
        return this;
    }

    @ApiModelProperty(example="null", value="A subset of the Journey System's customer data at a point-in-time (for external linkage and internal usage/context)")
    @JsonProperty(value="customer")
    public JourneyCustomer getCustomer() {
        return this.customer;
    }

    public void setCustomer(JourneyCustomer customer) {
        this.customer = customer;
    }

    public JourneyContext customerSession(JourneyCustomerSession customerSession) {
        this.customerSession = customerSession;
        return this;
    }

    @ApiModelProperty(example="null", value="A subset of the Journey System's tracked customer session data at a point-in-time (for external linkage and internal usage/context)")
    @JsonProperty(value="customerSession")
    public JourneyCustomerSession getCustomerSession() {
        return this.customerSession;
    }

    public void setCustomerSession(JourneyCustomerSession customerSession) {
        this.customerSession = customerSession;
    }

    public JourneyContext triggeringAction(JourneyAction triggeringAction) {
        this.triggeringAction = triggeringAction;
        return this;
    }

    @ApiModelProperty(example="null", value="A subset of the Journey System's action data relevant to a part of a conversation (for external linkage and internal usage/context)")
    @JsonProperty(value="triggeringAction")
    public JourneyAction getTriggeringAction() {
        return this.triggeringAction;
    }

    public void setTriggeringAction(JourneyAction triggeringAction) {
        this.triggeringAction = triggeringAction;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JourneyContext journeyContext = (JourneyContext)o;
        return Objects.equals(this.customer, journeyContext.customer) && Objects.equals(this.customerSession, journeyContext.customerSession) && Objects.equals(this.triggeringAction, journeyContext.triggeringAction);
    }

    public int hashCode() {
        return Objects.hash(this.customer, this.customerSession, this.triggeringAction);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class JourneyContext {\n");
        sb.append("    customer: ").append(this.toIndentedString(this.customer)).append("\n");
        sb.append("    customerSession: ").append(this.toIndentedString(this.customerSession)).append("\n");
        sb.append("    triggeringAction: ").append(this.toIndentedString(this.triggeringAction)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

