/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.HashMap;
import java.util.Map;

public class GetAttributeRequest {
    private String attributeId;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getAttributeId() {
        return this.attributeId;
    }

    public void setAttributeId(String attributeId) {
        this.attributeId = attributeId;
    }

    public GetAttributeRequest withAttributeId(String attributeId) {
        this.setAttributeId(attributeId);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public GetAttributeRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        if (this.attributeId == null) {
            throw new IllegalStateException("Missing the required parameter 'attributeId' when building request for GetAttributeRequest.");
        }
        return ApiRequestBuilder.create("GET", "/api/v2/attributes/{attributeId}").withPathParameter("attributeId", this.attributeId).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String attributeId) {
        return new Builder().withRequiredParams(attributeId);
    }

    public static class Builder {
        private final GetAttributeRequest request = new GetAttributeRequest();

        private Builder() {
        }

        public Builder withAttributeId(String attributeId) {
            this.request.setAttributeId(attributeId);
            return this;
        }

        public Builder withRequiredParams(String attributeId) {
            this.request.setAttributeId(attributeId);
            return this;
        }

        public GetAttributeRequest build() {
            if (this.request.attributeId == null) {
                throw new IllegalStateException("Missing the required parameter 'attributeId' when building request for GetAttributeRequest.");
            }
            return this.request;
        }
    }
}

