/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.ApiException;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiResponse;
import com.mypurecloud.sdk.v2.Configuration;
import com.mypurecloud.sdk.v2.api.request.DeleteStationAssociateduserRequest;
import com.mypurecloud.sdk.v2.api.request.GetStationRequest;
import com.mypurecloud.sdk.v2.api.request.GetStationsRequest;
import com.mypurecloud.sdk.v2.model.Station;
import com.mypurecloud.sdk.v2.model.StationEntityListing;
import java.io.IOException;

public class StationsApi {
    private final ApiClient pcapiClient;

    public StationsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public StationsApi(ApiClient apiClient) {
        this.pcapiClient = apiClient;
    }

    public String deleteStationAssociateduser(String stationId) throws IOException, ApiException {
        return this.deleteStationAssociateduser(this.createDeleteStationAssociateduserRequest(stationId));
    }

    public ApiResponse<String> deleteStationAssociateduserWithHttpInfo(String stationId) throws IOException {
        return this.deleteStationAssociateduser(this.createDeleteStationAssociateduserRequest(stationId).withHttpInfo());
    }

    private DeleteStationAssociateduserRequest createDeleteStationAssociateduserRequest(String stationId) {
        return DeleteStationAssociateduserRequest.builder().withStationId(stationId).build();
    }

    public String deleteStationAssociateduser(DeleteStationAssociateduserRequest request) throws IOException, ApiException {
        try {
            ApiResponse<String> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<String>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<String> deleteStationAssociateduser(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<String>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public Station getStation(String stationId) throws IOException, ApiException {
        return this.getStation(this.createGetStationRequest(stationId));
    }

    public ApiResponse<Station> getStationWithHttpInfo(String stationId) throws IOException {
        return this.getStation(this.createGetStationRequest(stationId).withHttpInfo());
    }

    private GetStationRequest createGetStationRequest(String stationId) {
        return GetStationRequest.builder().withStationId(stationId).build();
    }

    public Station getStation(GetStationRequest request) throws IOException, ApiException {
        try {
            ApiResponse<Station> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<Station>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<Station> getStation(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<Station>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public StationEntityListing getStations(Integer pageSize, Integer pageNumber, String sortBy, String name, String id, String lineAppearanceId) throws IOException, ApiException {
        return this.getStations(this.createGetStationsRequest(pageSize, pageNumber, sortBy, name, id, lineAppearanceId));
    }

    public ApiResponse<StationEntityListing> getStationsWithHttpInfo(Integer pageSize, Integer pageNumber, String sortBy, String name, String id, String lineAppearanceId) throws IOException {
        return this.getStations(this.createGetStationsRequest(pageSize, pageNumber, sortBy, name, id, lineAppearanceId).withHttpInfo());
    }

    private GetStationsRequest createGetStationsRequest(Integer pageSize, Integer pageNumber, String sortBy, String name, String id, String lineAppearanceId) {
        return GetStationsRequest.builder().withPageSize(pageSize).withPageNumber(pageNumber).withSortBy(sortBy).withName(name).withId(id).withLineAppearanceId(lineAppearanceId).build();
    }

    public StationEntityListing getStations(GetStationsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<StationEntityListing> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<StationEntityListing>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<StationEntityListing> getStations(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<StationEntityListing>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }
}

