/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.model.LanguageReference;
import com.mypurecloud.sdk.v2.model.QueueReference;
import com.mypurecloud.sdk.v2.model.RoutingSkillReference;
import com.mypurecloud.sdk.v2.model.UserReference;
import com.mypurecloud.sdk.v2.model.WfmTimeZone;
import com.mypurecloud.sdk.v2.model.WfmVersionedEntityMetadata;
import com.mypurecloud.sdk.v2.model.WorkPlanReference;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Workforce management agent data")
public class WfmAgent
implements Serializable {
    private String id = null;
    private UserReference user = null;
    private List<QueueReference> queues = new ArrayList<QueueReference>();
    private List<LanguageReference> languages = new ArrayList<LanguageReference>();
    private List<RoutingSkillReference> skills = new ArrayList<RoutingSkillReference>();
    private WorkPlanReference workPlan = null;
    private Boolean schedulable = null;
    private WfmTimeZone timeZone = null;
    private WfmVersionedEntityMetadata metadata = null;
    private String selfUri = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public WfmAgent user(UserReference user) {
        this.user = user;
        return this;
    }

    @ApiModelProperty(example="null", value="The user associated with this data")
    @JsonProperty(value="user")
    public UserReference getUser() {
        return this.user;
    }

    public void setUser(UserReference user) {
        this.user = user;
    }

    public WfmAgent queues(List<QueueReference> queues) {
        this.queues = queues;
        return this;
    }

    @ApiModelProperty(example="null", value="List of queues to which the agent belongs and which are defined in the service goal groups in this management unit")
    @JsonProperty(value="queues")
    public List<QueueReference> getQueues() {
        return this.queues;
    }

    public void setQueues(List<QueueReference> queues) {
        this.queues = queues;
    }

    public WfmAgent languages(List<LanguageReference> languages) {
        this.languages = languages;
        return this;
    }

    @ApiModelProperty(example="null", value="The list of languages")
    @JsonProperty(value="languages")
    public List<LanguageReference> getLanguages() {
        return this.languages;
    }

    public void setLanguages(List<LanguageReference> languages) {
        this.languages = languages;
    }

    public WfmAgent skills(List<RoutingSkillReference> skills) {
        this.skills = skills;
        return this;
    }

    @ApiModelProperty(example="null", value="The list of skills")
    @JsonProperty(value="skills")
    public List<RoutingSkillReference> getSkills() {
        return this.skills;
    }

    public void setSkills(List<RoutingSkillReference> skills) {
        this.skills = skills;
    }

    public WfmAgent workPlan(WorkPlanReference workPlan) {
        this.workPlan = workPlan;
        return this;
    }

    @ApiModelProperty(example="null", value="The work plan associated with this agent")
    @JsonProperty(value="workPlan")
    public WorkPlanReference getWorkPlan() {
        return this.workPlan;
    }

    public void setWorkPlan(WorkPlanReference workPlan) {
        this.workPlan = workPlan;
    }

    public WfmAgent schedulable(Boolean schedulable) {
        this.schedulable = schedulable;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether the agent has the permission to be included in schedule generation")
    @JsonProperty(value="schedulable")
    public Boolean getSchedulable() {
        return this.schedulable;
    }

    public void setSchedulable(Boolean schedulable) {
        this.schedulable = schedulable;
    }

    public WfmAgent timeZone(WfmTimeZone timeZone) {
        this.timeZone = timeZone;
        return this;
    }

    @ApiModelProperty(example="null", value="The time zone for this agent. Defaults to the time zone of the management unit to which the agent belongs")
    @JsonProperty(value="timeZone")
    public WfmTimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(WfmTimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public WfmAgent metadata(WfmVersionedEntityMetadata metadata) {
        this.metadata = metadata;
        return this;
    }

    @ApiModelProperty(example="null", value="Metadata for this agent")
    @JsonProperty(value="metadata")
    public WfmVersionedEntityMetadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(WfmVersionedEntityMetadata metadata) {
        this.metadata = metadata;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WfmAgent wfmAgent = (WfmAgent)o;
        return Objects.equals(this.id, wfmAgent.id) && Objects.equals(this.user, wfmAgent.user) && Objects.equals(this.queues, wfmAgent.queues) && Objects.equals(this.languages, wfmAgent.languages) && Objects.equals(this.skills, wfmAgent.skills) && Objects.equals(this.workPlan, wfmAgent.workPlan) && Objects.equals(this.schedulable, wfmAgent.schedulable) && Objects.equals(this.timeZone, wfmAgent.timeZone) && Objects.equals(this.metadata, wfmAgent.metadata) && Objects.equals(this.selfUri, wfmAgent.selfUri);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.user, this.queues, this.languages, this.skills, this.workPlan, this.schedulable, this.timeZone, this.metadata, this.selfUri);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WfmAgent {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    queues: ").append(this.toIndentedString(this.queues)).append("\n");
        sb.append("    languages: ").append(this.toIndentedString(this.languages)).append("\n");
        sb.append("    skills: ").append(this.toIndentedString(this.skills)).append("\n");
        sb.append("    workPlan: ").append(this.toIndentedString(this.workPlan)).append("\n");
        sb.append("    schedulable: ").append(this.toIndentedString(this.schedulable)).append("\n");
        sb.append("    timeZone: ").append(this.toIndentedString(this.timeZone)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

