/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;

public class LineIntegrationRequest
implements Serializable {
    private String id = null;
    private String name = null;
    private String channelId = null;
    private String channelSecret = null;
    private String switcherSecret = null;
    private String channelAccessToken = null;
    private String selfUri = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public LineIntegrationRequest name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The name of the LINE Integration")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public LineIntegrationRequest channelId(String channelId) {
        this.channelId = channelId;
        return this;
    }

    @ApiModelProperty(example="null", value="The Channel Id from LINE messenger. New Official LINE account: To create a new official account, LINE requires a Webhook URL. It can be created without specifying Channel Id & Channel Secret. Once the Official account is created by LINE, use the update LINE Integration API to update Channel Id and Channel Secret.  All other accounts: Channel Id is mandatory")
    @JsonProperty(value="channelId")
    public String getChannelId() {
        return this.channelId;
    }

    public void setChannelId(String channelId) {
        this.channelId = channelId;
    }

    public LineIntegrationRequest channelSecret(String channelSecret) {
        this.channelSecret = channelSecret;
        return this;
    }

    @ApiModelProperty(example="null", value="The Channel Secret from LINE messenger. New Official LINE account: To create a new official account, LINE requires a Webhook URL. It can be created without specifying Channel Id & Channel Secret. Once the Official account is created by LINE, use the update LINE Integration API to update Channel Id and Channel Secret.  All other accounts: Channel Secret is mandatory")
    @JsonProperty(value="channelSecret")
    public String getChannelSecret() {
        return this.channelSecret;
    }

    public void setChannelSecret(String channelSecret) {
        this.channelSecret = channelSecret;
    }

    public LineIntegrationRequest switcherSecret(String switcherSecret) {
        this.switcherSecret = switcherSecret;
        return this;
    }

    @ApiModelProperty(example="null", value="The Switcher Secret from LINE messenger. Some line official accounts are switcher functionality enabled. If the LINE account used for this integration is switcher enabled, then switcher secret is a required field. This secret can be found in your create documentation provided by LINE")
    @JsonProperty(value="switcherSecret")
    public String getSwitcherSecret() {
        return this.switcherSecret;
    }

    public void setSwitcherSecret(String switcherSecret) {
        this.switcherSecret = switcherSecret;
    }

    public LineIntegrationRequest channelAccessToken(String channelAccessToken) {
        this.channelAccessToken = channelAccessToken;
        return this;
    }

    @ApiModelProperty(example="null", value="The Channel Access Token from LINE messenger")
    @JsonProperty(value="channelAccessToken")
    public String getChannelAccessToken() {
        return this.channelAccessToken;
    }

    public void setChannelAccessToken(String channelAccessToken) {
        this.channelAccessToken = channelAccessToken;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LineIntegrationRequest lineIntegrationRequest = (LineIntegrationRequest)o;
        return Objects.equals(this.id, lineIntegrationRequest.id) && Objects.equals(this.name, lineIntegrationRequest.name) && Objects.equals(this.channelId, lineIntegrationRequest.channelId) && Objects.equals(this.channelSecret, lineIntegrationRequest.channelSecret) && Objects.equals(this.switcherSecret, lineIntegrationRequest.switcherSecret) && Objects.equals(this.channelAccessToken, lineIntegrationRequest.channelAccessToken) && Objects.equals(this.selfUri, lineIntegrationRequest.selfUri);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.channelId, this.channelSecret, this.switcherSecret, this.channelAccessToken, this.selfUri);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LineIntegrationRequest {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    channelId: ").append(this.toIndentedString(this.channelId)).append("\n");
        sb.append("    channelSecret: ").append(this.toIndentedString(this.channelSecret)).append("\n");
        sb.append("    switcherSecret: ").append(this.toIndentedString(this.switcherSecret)).append("\n");
        sb.append("    channelAccessToken: ").append(this.toIndentedString(this.channelAccessToken)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

